/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.DFStackNode;
import jtabwb.engine.DFStackNode_Branch;
import jtabwb.engine.DFStackNode_BranchExists;
import jtabwb.engine.ImplementationError;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.RuleType;
import jtabwb.engine.TraceNode;
import jtabwb.engine._ClashDetectionRule;

class TraceStack {
    private TNode head = null;
    private TNode top = null;
    GeneratingPremise nodeGeneratingPremise = null;

    void pushWithDFStackModified(TraceNode traceNode, DFStackNode dfNode) {
        TNode tmp;
        this.top = tmp = new TNode(traceNode, dfNode, this.top, this.nodeGeneratingPremise);
        if (this.head == null) {
            this.head = this.top;
        }
        if (dfNode instanceof DFStackNode_Branch) {
            this.nodeGeneratingPremise = new GeneratingPremise(traceNode, ((DFStackNode_Branch)dfNode).getIndexOfLastTreatedConclusion());
        }
        if (dfNode instanceof DFStackNode_BranchExists) {
            this.nodeGeneratingPremise = new GeneratingPremise(traceNode, ((DFStackNode_BranchExists)dfNode).getIndexOfLastTreatedConclusion());
        }
    }

    void pushWithDFStackUnchanged(TraceNode traceNode) {
        TNode tmp;
        this.top = tmp = new TNode(traceNode, null, this.top, this.nodeGeneratingPremise);
        if (this.head == null) {
            this.head = this.top;
        }
        switch (RuleType.getType(traceNode.appliedRule)) {
            case BRANCH_EXISTS: 
            case REGULAR: {
                this.nodeGeneratingPremise = new GeneratingPremise(traceNode, 0);
                break;
            }
            case CLASH_DETECTION_RULE: 
            case META_BACKTRACK_RULE: 
            case FORCE_BRANCH_FAILURE: 
            case FORCE_BRANCH_SUCCESS: {
                break;
            }
            default: {
                throw new ImplementationError();
            }
        }
    }

    private TraceNode restoreUntilWithProofStatus(DFStackNode wheretoStop, ProofSearchResult result) {
        TNode tmp = this.top;
        do {
            if (!(tmp.traceNode.appliedRule instanceof _ClashDetectionRule)) {
                tmp.traceNode.status = result;
            }
            tmp = tmp.previous;
        } while (tmp.dfNode != wheretoStop);
        this.top = tmp;
        if (wheretoStop != null) {
            this.nodeGeneratingPremise = this.top.dfNode instanceof DFStackNode_Branch ? new GeneratingPremise(this.top.traceNode, ((DFStackNode_Branch)this.top.dfNode).nextConclusionToTreat) : (this.top.dfNode instanceof DFStackNode_BranchExists ? new GeneratingPremise(this.top.traceNode, ((DFStackNode_BranchExists)this.top.dfNode).nextToTreat) : this.top.generatingPremise);
        }
        return tmp.traceNode;
    }

    public TraceNode restoreBranchPoint(DFStackNode branchPoint) {
        return this.restoreUntilWithProofStatus(branchPoint, ProofSearchResult.SUCCESS);
    }

    public TraceNode restoreBacktrackPoint(DFStackNode backtrackPoint) {
        return this.restoreUntilWithProofStatus(backtrackPoint, ProofSearchResult.FAILURE);
    }

    public TraceNode closeTrace(ProofSearchResult status) {
        if (this.top == null) {
            return this.head.traceNode;
        }
        TNode tmp = this.top;
        do {
            if (!(tmp.traceNode.appliedRule instanceof _ClashDetectionRule)) {
                tmp.traceNode.status = status;
            }
            this.top = tmp;
        } while ((tmp = tmp.previous) != null);
        return this.top.traceNode;
    }

    static class GeneratingPremise {
        TraceNode node;
        int idxConclusion;

        public GeneratingPremise(TraceNode node, int idxConclusion) {
            this.node = node;
            this.idxConclusion = idxConclusion;
        }
    }

    private static class TNode {
        TraceNode traceNode;
        DFStackNode dfNode;
        TNode previous;
        GeneratingPremise generatingPremise;

        public TNode(TraceNode traceNode, DFStackNode dfNode, TNode previous, GeneratingPremise gp) {
            this.traceNode = traceNode;
            this.dfNode = dfNode;
            this.previous = previous;
            this.generatingPremise = gp;
        }
    }
}

