/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import jtabwb.engine.Trace;
import jtabwb.engine.TraceNode;

class TraceIterator
implements Iterator<TraceNode> {
    private Stack<TraceNode> stack = new Stack();
    private TraceNode currentNode;

    public TraceIterator(Trace trace) {
        this.currentNode = trace.getProofSearchTree();
    }

    @Override
    public boolean hasNext() {
        return this.currentNode != null;
    }

    private TraceNode inOrder() {
        if (this.currentNode == null) {
            throw new NoSuchElementException();
        }
        TraceNode result = this.currentNode;
        if (this.currentNode.children != null) {
            LinkedList<TraceNode> children = this.currentNode.children;
            this.currentNode = children.get(0);
            int i = children.size() - 1;
            while (i >= 1) {
                this.stack.push(children.get(i));
                --i;
            }
        } else {
            this.currentNode = !this.stack.isEmpty() ? this.stack.pop() : null;
        }
        return result;
    }

    @Override
    public TraceNode next() {
        return this.inOrder();
    }

    @Override
    public void remove() {
    }
}

