/*
 * Decompiled with CFR 0.152.
 */
package ipl.rj.tp;

import ipl.lsj.sequent.AvailableLSJSequentImplementations;
import ipl.lsj.sequent.LSJFormulaFactory;
import ipl.rj.tp.RJLatexProofFormatter;
import ipl.rj.tp.RJStrategy;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine._Prover;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwb.tracesupport._LatexSupport;

public class RJProver
implements _Prover,
_LatexSupport {
    private final String DESCRIPTION = "RJ prover";
    private final String NAME = "rj";
    private final String VERSION = "1.0";
    private static AvailableLSJSequentImplementations DEFAULT_SEQUENT_IMPLEMENTATION = AvailableLSJSequentImplementations.SEQ_ARRAY;
    private AvailableLSJSequentImplementations selectedSequentImplementation;
    private LSJFormulaFactory factory;
    private _Strategy strategy;
    private ProverName proverName;

    public RJProver() {
        this(DEFAULT_SEQUENT_IMPLEMENTATION);
    }

    public RJProver(AvailableLSJSequentImplementations sequentImplementation) {
        this.selectedSequentImplementation = sequentImplementation;
        this.factory = new LSJFormulaFactory();
        this.proverName = new ProverName("rj");
        this.proverName.setDescription("RJ prover");
        this.proverName.setVersion("1.0");
        this.configure(sequentImplementation);
    }

    public void configure(AvailableLSJSequentImplementations impl) {
        this.selectedSequentImplementation = impl;
        this.strategy = new RJStrategy(this.factory);
        this.proverName.setVariant("seq=" + this.selectedSequentImplementation.getName());
    }

    @Override
    public _Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ProverName getProverName() {
        return this.proverName;
    }

    @Override
    public ProvabilityStatus statusFor(ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                return ProvabilityStatus.UNPROVABLE;
            }
            case FAILURE: {
                return ProvabilityStatus.PROVABLE;
            }
        }
        throw new RuntimeException("This case should not occur " + (result == null ? "null" : result));
    }

    @Override
    public _LatexCTreeFormatter getLatexProofFormatter() {
        return new RJLatexProofFormatter();
    }
}

