/*
 * Decompiled with CFR 0.152.
 */
package ipl.rj.calculus;

import ipl.lsj.sequent._LSJSequent;
import ipl.rj.calculus.ImplementationError;
import ipl.rj.calculus.RJAbstractRegularRule;
import ipl.rj.calculus.RJCalculus;
import ipl.rj.calculus.RJRuleIdentifier;
import java.util.Collection;
import java.util.LinkedList;
import jtabwb.engine.NoSuchSubgoalException;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.Formula;

public class Rule_Succ
extends RJAbstractRegularRule {
    private _LSJSequent premise;
    private LinkedList<Formula> leftFormulas;
    private LinkedList<Formula> rightFormulas;
    private Formula FALSE;

    private Rule_Succ(_LSJSequent goal, Formula FALSE, LinkedList<Formula> leftFormulas, LinkedList<Formula> rightFormulas, int numberOfConclusions) {
        super(RJRuleIdentifier.RULE_SUCC, goal, null, numberOfConclusions);
        this.premise = goal;
        this.FALSE = FALSE;
        this.leftFormulas = leftFormulas;
        this.rightFormulas = rightFormulas;
    }

    public static Rule_Succ buildInstance(_LSJSequent goal, Formula FALSE) {
        Collection<Formula> set;
        if (!Rule_Succ.check_1(goal)) {
            return null;
        }
        LinkedList<Formula> leftFormulas = new LinkedList<Formula>();
        LinkedList<Formula> rightFormulas = new LinkedList<Formula>();
        for (FormulaType type : RJCalculus.LEFT_NON_INVERTIBLE) {
            set = goal.getLeftFormulas(type);
            if (set == null) continue;
            leftFormulas.addAll(set);
        }
        for (FormulaType type : RJCalculus.RIGHT_NON_INVERTIBLE) {
            set = goal.getRightFormulas(type);
            if (set == null) continue;
            rightFormulas.addAll(set);
        }
        int numberOfConclusions = leftFormulas.size() + rightFormulas.size();
        if (numberOfConclusions == 0) {
            return null;
        }
        return new Rule_Succ(goal, FALSE, leftFormulas, rightFormulas, numberOfConclusions);
    }

    public static boolean check_1(_LSJSequent sequent) {
        return !sequent.containsFalseInLeftHandSide() && !sequent.containsTrueInRightHandSide() && !sequent.containsLeft(FormulaType.OR_WFF) && !sequent.containsLeft(FormulaType.AND_WFF) && !sequent.containsRight(FormulaType.AND_WFF) && !sequent.containsRight(FormulaType.OR_WFF) && !sequent.isIdentityAxiom();
    }

    public static boolean isApplicable(_LSJSequent sequent) {
        if (!Rule_Succ.check_1(sequent)) {
            return false;
        }
        return sequent.containsLeft(RJCalculus.LEFT_NON_INVERTIBLE) || sequent.containsRight(RJCalculus.RIGHT_NON_INVERTIBLE);
    }

    private _LSJSequent branchLeftFor(_LSJSequent premise, Formula toTreat) {
        _LSJSequent consequent = premise.clone();
        consequent.stable();
        consequent.removeLeft(toTreat);
        PropositionalConnective connective = toTreat.mainConnective();
        switch (connective) {
            case IMPLIES: {
                Formula antecedent = toTreat.immediateSubformulas()[0];
                Formula conseqent = toTreat.immediateSubformulas()[1];
                consequent.addRight(antecedent);
                consequent.addContext(conseqent);
                return consequent;
            }
            case NOT: {
                Formula subwff = toTreat.immediateSubformulas()[0];
                consequent.addContext(this.FALSE);
                consequent.addRight(subwff);
                return consequent;
            }
        }
        throw new ImplementationError("case not treated!");
    }

    private _LSJSequent branchRightFor(_LSJSequent premise, Formula toTreat) {
        _LSJSequent consequent = premise.clone();
        consequent.stable();
        PropositionalConnective connective = toTreat.mainConnective();
        switch (connective) {
            case IMPLIES: {
                Formula antecedent = toTreat.immediateSubformulas()[0];
                Formula conseqent = toTreat.immediateSubformulas()[1];
                consequent.addLeft(antecedent);
                consequent.addRight(conseqent);
                return consequent;
            }
            case NOT: {
                consequent.addLeft(toTreat.immediateSubformulas()[0]);
                return consequent;
            }
        }
        throw new ImplementationError("case not treated!");
    }

    @Override
    public _LSJSequent conclusion(int i) throws NoSuchSubgoalException {
        if (i < 0 || i >= this.NUMBER_OF_CONCLUSIONS) {
            throw new NoSuchSubgoalException("Undefined branch: " + i);
        }
        if (i < this.leftFormulas.size()) {
            return this.branchLeftFor(this.premise, this.leftFormulas.get(i));
        }
        return this.branchRightFor(this.premise, this.rightFormulas.get(i - this.leftFormulas.size()));
    }
}

