/*
 * Decompiled with CFR 0.152.
 */
package ipl.rj.calculus;

import ipl.lsj.sequent._LSJSequent;
import ipl.rj.calculus.ImplementationError;
import ipl.rj.calculus.RJClashDetectionRule;
import ipl.rj.calculus.RJRuleIdentifier;
import ipl.rj.calculus.Rule_Left_And;
import ipl.rj.calculus.Rule_Left_Implies;
import ipl.rj.calculus.Rule_Left_Not;
import ipl.rj.calculus.Rule_Left_Or;
import ipl.rj.calculus.Rule_Right_And;
import ipl.rj.calculus.Rule_Right_Implies;
import ipl.rj.calculus.Rule_Right_Not;
import ipl.rj.calculus.Rule_Right_Or;
import ipl.rj.calculus.Rule_Succ;
import ipl.rj.calculus._RJAbstractRule;
import java.util.EnumSet;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaProposition;

public class RJCalculus {
    public static final EnumSet<FormulaType> LEFT_NON_INVERTIBLE = EnumSet.of(FormulaType.IMPLIES_WFF, FormulaType.NOT_WFF);
    public static final EnumSet<FormulaType> RIGHT_NON_INVERTIBLE = EnumSet.of(FormulaType.IMPLIES_WFF, FormulaType.NOT_WFF);
    private FormulaProposition FALSE;

    public RJCalculus(FormulaProposition FALSE) {
        this.FALSE = FALSE;
    }

    public _RJAbstractRule getRule(RJRuleIdentifier ruleId, _LSJSequent goal, Formula mainFormula) {
        switch (ruleId) {
            case CLASH_DETECTION: {
                return new RJClashDetectionRule(goal);
            }
            case LEFT_AND: {
                return new Rule_Left_And(goal, mainFormula);
            }
            case RIGHT_AND: {
                return new Rule_Right_And(goal, mainFormula);
            }
            case LEFT_OR: {
                return new Rule_Left_Or(goal, mainFormula);
            }
            case RIGHT_OR: {
                return new Rule_Right_Or(goal, mainFormula);
            }
            case LEFT_IMPLIES: {
                return new Rule_Left_Implies(goal, mainFormula);
            }
            case RIGHT_IMPLIES: {
                return new Rule_Right_Implies(goal, mainFormula);
            }
            case LEFT_NOT: {
                return new Rule_Left_Not(goal, mainFormula, this.FALSE);
            }
            case RIGHT_NOT: {
                return new Rule_Right_Not(goal, mainFormula);
            }
            case RULE_SUCC: {
                return Rule_Succ.buildInstance(goal, this.FALSE);
            }
        }
        throw new ImplementationError();
    }
}

