/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.tp;

import ipl.lsj.sequent.AvailableLSJSequentImplementations;
import ipl.lsj.sequent.LSJFormulaFactory;
import ipl.lsj.tp.ImplementationError;
import ipl.lsj.tp.LSJLatexProofFormatter;
import ipl.lsj.tp.LSJTraceManager;
import ipl.lsj.tp.Strategy;
import ipl.lsj.tp.StrategyOnBSF;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine._Prover;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwb.tracesupport._LatexSupport;
import jtabwb.tracesupport._TraceManager;
import jtabwb.tracesupport._TraceSupport;

public class LSJProver
implements _Prover,
_LatexSupport,
_TraceSupport {
    private AvailableLSJSequentImplementations selectedSequentImplementation;
    public static AvailableLSJSequentImplementations DEFAULT_SEQUENT_IMPLEMENTATION = AvailableLSJSequentImplementations.SEQ_BSF;
    private final String NAME = "lsj";
    private final String DESCRIPTION = "LSJ prover";
    private final String VERSION = "1.0";
    private final ProverName proverName;
    private LSJFormulaFactory factory;
    private _Strategy strategy;

    public LSJProver() {
        this(DEFAULT_SEQUENT_IMPLEMENTATION);
    }

    public LSJProver(AvailableLSJSequentImplementations sequentImplementation) {
        this.selectedSequentImplementation = sequentImplementation;
        this.factory = new LSJFormulaFactory();
        this.proverName = new ProverName("lsj");
        this.proverName.setDescription("LSJ prover");
        this.proverName.setVersion("1.0");
        this.configure(sequentImplementation);
    }

    public void configure(AvailableLSJSequentImplementations impl) {
        this.selectedSequentImplementation = impl;
        switch (impl) {
            case SEQ_ARRAY: 
            case SEQ_BITSET: 
            case SEQ_LIST: {
                this.strategy = new Strategy(this.factory);
                break;
            }
            case SEQ_BSF: {
                this.strategy = new StrategyOnBSF(this.factory);
                break;
            }
            default: {
                throw new ImplementationError();
            }
        }
        this.proverName.setVariant("seq=" + this.selectedSequentImplementation.getName());
    }

    @Override
    public _Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ProverName getProverName() {
        return this.proverName;
    }

    @Override
    public ProvabilityStatus statusFor(ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                return ProvabilityStatus.PROVABLE;
            }
            case FAILURE: {
                return ProvabilityStatus.UNPROVABLE;
            }
        }
        throw new RuntimeException("This case should not occur " + (result == null ? "null" : result));
    }

    @Override
    public _LatexCTreeFormatter getLatexProofFormatter() {
        return new LSJLatexProofFormatter();
    }

    @Override
    public _TraceManager getTraceManager() {
        return new LSJTraceManager();
    }
}

