/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.tp;

import ipl.lsj.calculus.LSJCalculus;
import ipl.lsj.calculus.Rule_Left_Implies;
import ipl.lsj.calculus.Rule_Left_Not;
import ipl.lsj.calculus.Rule_Right_Implies;
import ipl.lsj.calculus.Rule_Right_Not;
import ipl.lsj.sequent._LSJSequent;
import ipl.lsj.tp.ImplementationError;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwb.engine.NoSuchBacktrackRuleException;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;

class LSJMetaBacktrackRule
implements _MetaBacktrackRule {
    public static final String NAME = "META-LSJ";
    private _LSJSequent premise;
    private LinkedList<Formula> rightNonInvertibleFormulas;
    private LinkedList<Formula> leftNonInvertibleFormulas;
    private int totalNumberOfRules;
    private Iterator<Formula> leftIterator;
    private Iterator<Formula> rightIterator;

    public LSJMetaBacktrackRule(_LSJSequent goal) {
        Collection<Formula> set;
        this.premise = goal;
        this.rightNonInvertibleFormulas = new LinkedList();
        for (FormulaType type : LSJCalculus.RIGHT_NON_INVERTIBLE) {
            set = goal.getRightFormulas(type);
            if (set == null) continue;
            this.rightNonInvertibleFormulas.addAll(set);
        }
        this.leftNonInvertibleFormulas = new LinkedList();
        for (FormulaType type : LSJCalculus.LEFT_NON_INVERTIBLE) {
            set = goal.getLeftFormulas(type);
            if (set == null) continue;
            this.leftNonInvertibleFormulas.addAll(set);
        }
        this.leftIterator = this.leftNonInvertibleFormulas.iterator();
        this.rightIterator = this.rightNonInvertibleFormulas.iterator();
        this.totalNumberOfRules = this.leftNonInvertibleFormulas.size() + this.rightNonInvertibleFormulas.size();
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public _LSJSequent goal() {
        return this.premise;
    }

    @Override
    public _AbstractRule nextRule() {
        if (this.rightIterator.hasNext()) {
            Formula mainFormula = this.rightIterator.next();
            switch (mainFormula.mainConnective()) {
                case IMPLIES: {
                    return new Rule_Right_Implies(this.premise, mainFormula);
                }
                case NOT: {
                    return new Rule_Right_Not(this.premise, mainFormula);
                }
            }
            throw new ImplementationError();
        }
        if (this.leftIterator.hasNext()) {
            Formula mainFormula = this.leftIterator.next();
            switch (mainFormula.mainConnective()) {
                case IMPLIES: {
                    return new Rule_Left_Implies(this.premise, mainFormula);
                }
                case NOT: {
                    return new Rule_Left_Not(this.premise, mainFormula);
                }
            }
            throw new ImplementationError();
        }
        throw new NoSuchBacktrackRuleException();
    }

    @Override
    public boolean hasNextRule() {
        return this.leftIterator.hasNext() || this.rightIterator.hasNext();
    }

    @Override
    public int totalNumberOfRules() {
        return this.totalNumberOfRules;
    }
}

