/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.tp;

import ipl.lsj.calculus.LSJClashDetectionRule;
import ipl.lsj.calculus.LSJRuleIdentifiers;
import ipl.lsj.calculus._LSJAbstractRule;
import ipl.lsj.sequent._LSJSequent;
import ipl.lsj.tp.ImplementationError;
import java.util.Collection;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.tracesupport.CTree;
import jtabwb.tracesupport.LatexTranslator;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.basic._PropositionalFormula;
import jtabwbx.prop.formula.Formula;

class LSJLatexProofFormatter
implements _LatexCTreeFormatter {
    final String SEQ_FORMAT = "\\seq{%s}{%s}{%s}";
    private final String LATEX_MACROS = "%% \\seq{Theta}{Gamma}{Delta} writes the sequent Theta;Gamma ==> Delta\n\\newcommand{\\seq}[3]{\n\\ifthenelse{\\isempty{#1}}{\\emptyset}{#1}\\, ;\n\\ifthenelse{\\isempty{#2}}{\\emptyset}{#2}\\, \\Rightarrow\n\\ifthenelse{\\isempty{#3}}{\\emptyset}{#3}\n}\n";
    private String[][] replacement = new String[][]{{"_", "\\\\_"}, {"\\$", "\\$"}};

    LSJLatexProofFormatter() {
    }

    @Override
    public String getPreamble() {
        return "%% \\seq{Theta}{Gamma}{Delta} writes the sequent Theta;Gamma ==> Delta\n\\newcommand{\\seq}[3]{\n\\ifthenelse{\\isempty{#1}}{\\emptyset}{#1}\\, ;\n\\ifthenelse{\\isempty{#2}}{\\emptyset}{#2}\\, \\Rightarrow\n\\ifthenelse{\\isempty{#3}}{\\emptyset}{#3}\n}\n";
    }

    @Override
    public LatexTranslator.ProofStyle proofStyle() {
        return LatexTranslator.ProofStyle.SEQUENT;
    }

    @Override
    public String getIntro() {
        return null;
    }

    @Override
    public boolean generateFailureGoalAnnotations() {
        return false;
    }

    @Override
    public String format(_AbstractGoal nodeSet) {
        _LSJSequent seq = (_LSJSequent)nodeSet;
        String s = String.format("\\seq{%s}{%s}{%s}", this.format(seq.getContextFormulas()), this.format(seq.getLeftFormulas()), this.format(seq.getRightFormulas()));
        return s;
    }

    private String format(Collection<Formula> set) {
        String str = "";
        if (set == null) {
            return "";
        }
        _PropositionalFormula[] swffs = set.toArray(new _PropositionalFormula[set.size()]);
        int i = 0;
        while (i < swffs.length) {
            str = String.valueOf(str) + this.format(swffs[i]) + (i < swffs.length - 1 ? "," : "");
            ++i;
        }
        return str;
    }

    private String format(_PropositionalFormula wff) {
        if (wff.isAtomic()) {
            String name = wff.format();
            if (name.equals("false")) {
                return "\\bot";
            }
            if (name.equals("true")) {
                return "\\top";
            }
            return this.correctName(name);
        }
        _PropositionalFormula[] subwffs = wff.immediateSubformulas();
        String connective = "";
        PropositionalConnective conn = wff.mainConnective();
        switch (conn) {
            case AND: {
                connective = " \\land ";
                break;
            }
            case OR: {
                connective = " \\lor ";
                break;
            }
            case NOT: {
                return " \\neg " + this.format(subwffs[0]);
            }
            case IMPLIES: {
                connective = " \\to ";
                break;
            }
            default: {
                throw new ImplementationError("Case non treated: " + conn.name());
            }
        }
        String str = "";
        int i = 0;
        while (i < subwffs.length) {
            str = String.valueOf(str) + this.format(subwffs[i]) + (i < subwffs.length - 1 ? connective : " ");
            ++i;
        }
        return "(" + str + ")";
    }

    @Override
    public String formatRuleName(_AbstractRule rule) {
        if (rule instanceof LSJClashDetectionRule) {
            return "\\textrm{Id}";
        }
        LSJRuleIdentifiers id = ((_LSJAbstractRule)rule).getRuleIdentifier();
        switch (id) {
            case LEFT_AND: {
                return "\\land\\textrm{L}";
            }
            case LEFT_OR: {
                return "\\lor\\textrm{L}";
            }
            case LEFT_IMPLIES: {
                return "\\to\\textrm{L}";
            }
            case LEFT_IMPLIES_CL: {
                return "\\to\\textrm{L}";
            }
            case LEFT_NOT: {
                return "\\neg\\textrm{L}";
            }
            case LEFT_NOT_CL: {
                return "\\neg\\textrm{L}";
            }
            case RIGHT_AND: {
                return "\\land\\textrm{R}";
            }
            case RIGHT_OR: {
                return "\\lor\\textrm{R}";
            }
            case RIGHT_IMPLIES: {
                return "\\to\\textrm{R}";
            }
            case RIGHT_IMPLIES_CL: {
                return "\\to\\textrm{R}";
            }
            case RIGHT_NOT: {
                return "\\neg\\textrm{R}";
            }
            case RIGHT_NOT_CL: {
                return "\\neg\\textrm{R}";
            }
        }
        return null;
    }

    private String correctName(String name) {
        String result = name;
        int i = 0;
        while (i < this.replacement.length) {
            result = result.replaceAll(this.replacement[i][0], this.replacement[i][1]);
            ++i;
        }
        return result;
    }

    @Override
    public boolean generateNodeSetIndex() {
        return false;
    }

    @Override
    public boolean generateRuleIndex() {
        return false;
    }

    @Override
    public String pre(CTree ctree) {
        return null;
    }

    @Override
    public String post(CTree ctree) {
        return null;
    }
}

