/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.tp;

import ipl.lsj.calculus.LSJCalculus;
import ipl.lsj.calculus.Rule_Left_Implies;
import ipl.lsj.calculus.Rule_Left_Not;
import ipl.lsj.calculus.Rule_Right_Implies;
import ipl.lsj.calculus.Rule_Right_Not;
import ipl.lsj.calculus._LSJAbstractRule;
import ipl.lsj.sequent._LSJSequent;
import ipl.lsj.tp.ImplementationError;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwb.engine.NoSuchBacktrackRuleException;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._OnRuleResumedListener;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;

class DynamicMetaBacktrackRule
implements _MetaBacktrackRule,
_OnRuleResumedListener {
    public static final String NAME = "META-LSJ";
    private _LSJSequent premise;
    private int totalNumberOfRules;
    private Iterator<Formula> leftIterator;
    private Iterator<Formula> rightIterator;
    private _LSJAbstractRule lastTreatedRule;
    private boolean treatRemaingLeftRules;
    private boolean treatRemaingRightRules;

    public DynamicMetaBacktrackRule(_LSJSequent goal) {
        this.premise = goal;
        LinkedList<Formula> rightNonInvertibleFormulas = new LinkedList<Formula>();
        for (FormulaType type : LSJCalculus.RIGHT_NON_INVERTIBLE) {
            Collection<Formula> set = goal.getRightFormulas(type);
            if (set == null) continue;
            rightNonInvertibleFormulas.addAll(set);
        }
        LinkedList<Formula> leftNonInvertibleFormulas = new LinkedList<Formula>();
        for (FormulaType type : LSJCalculus.LEFT_NON_INVERTIBLE) {
            Collection<Formula> set = goal.getLeftFormulas(type);
            if (set == null) continue;
            leftNonInvertibleFormulas.addAll(set);
        }
        this.leftIterator = leftNonInvertibleFormulas.iterator();
        this.treatRemaingLeftRules = this.leftIterator.hasNext();
        this.rightIterator = rightNonInvertibleFormulas.iterator();
        this.treatRemaingRightRules = this.rightIterator.hasNext();
        this.totalNumberOfRules = leftNonInvertibleFormulas.size() + rightNonInvertibleFormulas.size();
    }

    @Override
    public void onResumed() {
        switch (this.lastTreatedRule.getRuleIdentifier()) {
            case LEFT_IMPLIES: {
                if (!((Rule_Left_Implies)this.lastTreatedRule).lastTreatedConclusionWasTheInvertibleOne()) break;
                this.treatRemaingRightRules = false;
                this.treatRemaingLeftRules = false;
                break;
            }
            case LEFT_NOT: {
                if (!((Rule_Left_Not)this.lastTreatedRule).lastTreatedConclusionWasTheInvertibleOne()) break;
                this.treatRemaingRightRules = false;
                this.treatRemaingLeftRules = false;
                break;
            }
            case RIGHT_IMPLIES: {
                if (!((Rule_Right_Implies)this.lastTreatedRule).lastTreatedConclusionWasTheInvertibleOne()) break;
                this.treatRemaingRightRules = false;
                this.treatRemaingLeftRules = false;
                break;
            }
            case RIGHT_NOT: {
                if (!((Rule_Right_Not)this.lastTreatedRule).lastTreatedConclusionWasTheInvertibleOne()) break;
                this.treatRemaingRightRules = false;
                this.treatRemaingLeftRules = false;
                break;
            }
            default: {
                throw new ImplementationError();
            }
        }
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public _LSJSequent goal() {
        return this.premise;
    }

    @Override
    public _AbstractRule nextRule() {
        if (!this.treatRemaingRightRules && !this.treatRemaingLeftRules) {
            throw new NoSuchBacktrackRuleException();
        }
        if (this.rightIterator.hasNext()) {
            Formula mainFormula = this.rightIterator.next();
            this.treatRemaingRightRules = this.rightIterator.hasNext();
            switch (mainFormula.mainConnective()) {
                case IMPLIES: {
                    this.lastTreatedRule = new Rule_Right_Implies(this.premise, mainFormula);
                    return this.lastTreatedRule;
                }
                case NOT: {
                    this.lastTreatedRule = new Rule_Right_Not(this.premise, mainFormula);
                    return this.lastTreatedRule;
                }
            }
            throw new ImplementationError();
        }
        if (this.leftIterator.hasNext()) {
            Formula mainFormula = this.leftIterator.next();
            this.treatRemaingLeftRules = this.leftIterator.hasNext();
            switch (mainFormula.mainConnective()) {
                case IMPLIES: {
                    this.lastTreatedRule = new Rule_Left_Implies(this.premise, mainFormula);
                    return this.lastTreatedRule;
                }
                case NOT: {
                    this.lastTreatedRule = new Rule_Left_Not(this.premise, mainFormula);
                    return this.lastTreatedRule;
                }
            }
            throw new ImplementationError();
        }
        return null;
    }

    @Override
    public boolean hasNextRule() {
        return this.treatRemaingLeftRules || this.treatRemaingRightRules;
    }

    @Override
    public int totalNumberOfRules() {
        return this.totalNumberOfRules;
    }
}

