/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.sequent;

import ipl.lsj.sequent._LSJSequent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.SequentOnLists;

public class LSJSequentOnLists
extends SequentOnLists
implements _LSJSequent {
    private BitSetOfFormulas context;
    private FormulaFactory factory;

    public LSJSequentOnLists(FormulaFactory factory) {
        this.factory = factory;
        this.context = new BitSetOfFormulas(factory);
    }

    @Override
    public void addContext(Formula wff) {
        this.context.add(wff);
    }

    @Override
    public LSJSequentOnLists clone() {
        LSJSequentOnLists cloned = (LSJSequentOnLists)super.clone();
        cloned.factory = this.factory;
        cloned.context = this.context.clone();
        return cloned;
    }

    @Override
    public void stable() {
        Collection<Formula> contextWff = this.context.getAllFormulas();
        if (contextWff != null) {
            for (Formula wff : contextWff) {
                this.addLeft(wff);
            }
        }
        this.context.clear();
        this.clearRight();
    }

    @Override
    public boolean containsLeft(EnumSet<FormulaType> types) {
        for (FormulaType type : types) {
            if (!this.containsLeft(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsRight(EnumSet<FormulaType> types) {
        for (FormulaType type : types) {
            if (!this.containsRight(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsFalseInLeftHandSide() {
        return super.containsLeft(this.factory.getFalse());
    }

    @Override
    public boolean containsTrueInRightHandSide() {
        return super.containsRight(this.factory.getTrue());
    }

    @Override
    public boolean containsInContext(Formula formula) {
        return this.context.contains(formula);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (super.equals(obj)) {
            return this.context.equals(((LSJSequentOnLists)obj).context);
        }
        return false;
    }

    @Override
    public Collection<Formula> getContextFormulas() {
        return this.context.getAllFormulas();
    }

    @Override
    public boolean isContextEmpty() {
        return this.context.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.isContextEmpty();
    }

    @Override
    public void removeAllContextFormulas() {
        this.context.clear();
    }

    @Override
    public boolean removeContext(Formula wff) {
        return this.context.remove(wff);
    }

    @Override
    public String format() {
        return this.toString();
    }

    @Override
    public String toString() {
        String ctx = "";
        if (!this.context.isEmpty()) {
            Iterator<Formula> it = this.context.getAllFormulas().iterator();
            while (it.hasNext()) {
                ctx = String.valueOf(ctx) + it.next().format() + (it.hasNext() ? ", " : "");
            }
        }
        String seq = super.toString();
        return String.valueOf(ctx) + ";; " + seq;
    }

    @Override
    public Iterator<Formula> contextIterator() {
        return this.context.iterator();
    }
}

