/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.sequent;

import ipl.lsj.sequent._LSJSequent;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.SequentOnBitSet;

public class LSJSequentOnBitSet
extends SequentOnBitSet
implements _LSJSequent {
    private BitSet context;
    private LinkedList<Formula> contextFormulas;

    public LSJSequentOnBitSet(FormulaFactory factory) {
        super(factory);
        this.context = new BitSet(factory.numberOfGeneratedFormulas());
        this.contextFormulas = new LinkedList();
    }

    @Override
    public void addContext(Formula wff) {
        int idx = wff.getIndex();
        if (!this.context.get(idx)) {
            this.context.set(idx);
            this.contextFormulas.add(wff);
        }
    }

    @Override
    public Collection<Formula> getContextFormulas() {
        return this.contextFormulas.isEmpty() ? null : this.contextFormulas;
    }

    @Override
    public boolean containsFalseInLeftHandSide() {
        return super.containsLeft(this.getFormulaFactory().getFalse());
    }

    @Override
    public boolean containsTrueInRightHandSide() {
        return super.containsRight(this.getFormulaFactory().getTrue());
    }

    @Override
    public boolean containsInContext(Formula formula) {
        return this.context.get(formula.getIndex());
    }

    @Override
    public boolean containsLeft(EnumSet<FormulaType> types) {
        for (FormulaType type : types) {
            if (!this.containsLeft(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsRight(EnumSet<FormulaType> types) {
        for (FormulaType type : types) {
            if (!this.containsRight(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isContextEmpty() {
        return this.context.isEmpty();
    }

    @Override
    public void removeAllContextFormulas() {
        this.context.clear();
        this.contextFormulas = new LinkedList();
    }

    @Override
    public boolean removeContext(Formula wff) {
        int idx = wff.getIndex();
        if (this.context.get(idx)) {
            this.context.set(idx, false);
            this.contextFormulas.remove(wff);
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.context.isEmpty();
    }

    @Override
    public LSJSequentOnBitSet clone() {
        LSJSequentOnBitSet cloned = (LSJSequentOnBitSet)super.clone();
        cloned.context = (BitSet)this.context.clone();
        cloned.contextFormulas = (LinkedList)this.contextFormulas.clone();
        return cloned;
    }

    @Override
    public void stable() {
        for (Formula wff : this.contextFormulas) {
            this.addLeft(wff);
        }
        this.context.clear();
        this.contextFormulas = new LinkedList();
        this.clearRight();
    }

    @Override
    public String format() {
        return this.toString();
    }

    @Override
    public String toString() {
        String ctx = "";
        if (this.context != null) {
            Iterator it = this.contextFormulas.iterator();
            while (it.hasNext()) {
                ctx = String.valueOf(ctx) + ((Formula)it.next()).format() + (it.hasNext() ? ", " : "");
            }
        }
        String seq = super.toString();
        return String.valueOf(ctx) + ";; " + seq;
    }

    @Override
    public Iterator<Formula> contextIterator() {
        return this.contextFormulas.iterator();
    }
}

