/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.sequent;

import ipl.lsj.sequent._LSJSequent;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.SequentOnArray;

public class LSJSequentOnArray
extends SequentOnArray
implements _LSJSequent {
    private BitSetOfFormulas context;

    public LSJSequentOnArray(FormulaFactory factory) {
        super(factory);
        this.context = new BitSetOfFormulas(factory);
    }

    @Override
    public void addContext(Formula wff) {
        this.context.add(wff);
    }

    @Override
    public Collection<Formula> getContextFormulas() {
        return this.context.isEmpty() ? null : this.context.getAllFormulas();
    }

    @Override
    public boolean containsLeft(EnumSet<FormulaType> types) {
        for (FormulaType type : types) {
            if (!this.containsLeft(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsRight(EnumSet<FormulaType> types) {
        for (FormulaType type : types) {
            if (!this.containsRight(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsFalseInLeftHandSide() {
        return super.containsLeft(this.getFormulaFactory().getFalse());
    }

    @Override
    public boolean containsTrueInRightHandSide() {
        return super.containsRight(this.getFormulaFactory().getTrue());
    }

    @Override
    public boolean containsInContext(Formula formula) {
        return this.context.contains(formula);
    }

    @Override
    public boolean isContextEmpty() {
        return this.context.isEmpty();
    }

    @Override
    public void removeAllContextFormulas() {
        this.context.clear();
    }

    @Override
    public boolean removeContext(Formula wff) {
        return this.context.remove(wff);
    }

    @Override
    public boolean isEmpty() {
        return this.isLeftSideEmpty() && this.isLeftSideEmpty() && this.context == null;
    }

    @Override
    public LSJSequentOnArray clone() {
        LSJSequentOnArray cloned = (LSJSequentOnArray)super.clone();
        cloned.context = this.context.clone();
        return cloned;
    }

    @Override
    public void stable() {
        if (!this.context.isEmpty()) {
            for (Formula wff : this.context.getAllFormulas()) {
                this.addLeft(wff);
            }
        }
        this.context.clear();
        this.clearRight();
    }

    @Override
    public String format() {
        return this.toString();
    }

    @Override
    public String toString() {
        String ctx = "";
        if (!this.context.isEmpty()) {
            Iterator<Formula> it = this.context.getAllFormulas().iterator();
            while (it.hasNext()) {
                ctx = String.valueOf(ctx) + it.next().format() + (it.hasNext() ? ", " : "");
            }
        }
        String seq = super.toString();
        return String.valueOf(ctx) + ";; " + seq;
    }

    @Override
    public Iterator<Formula> contextIterator() {
        return this.context.iterator();
    }
}

