/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.launcher;

import ferram.messages.MessageManager;
import ipl.lsj.launcher.KripkeModel;
import ipl.lsj.launcher.LSJInitialNodeSetBuilder;
import ipl.lsj.launcher.LSJLauncherMessageManager;
import ipl.lsj.launcher.SelectableSequentsImplementation;
import ipl.lsj.launcher.SingelExecutionConfigurator;
import ipl.lsj.sequent.AvailableLSJSequentImplementations;
import ipl.lsj.tp.LSJProver;
import ipl.rj.tp.RJProver;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.Trace;
import jtabwb.launcher.Launcher;
import jtabwb.launcher.ProofSearchData;
import jtabwbx.problems.ILTPProblemReader;
import jtabwbx.problems.JTabWbSimpleProblemReader;
import jtabwbx.problems.PlainProblemReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Main {
    private final String OPTION_PROPERTIES_BUNDLE_NAME = String.valueOf(this.getClass().getPackage().getName()) + ".options";
    private static String WELCOME = "Launcher for lsj and rj (unprovability calculus) for IPL";
    private static String FORMULA_SYNTAX_DESCRIPTION = "Syntax of formulas\n  atoms: Java identifiers\nlogical: false, & (and), | (or), ~ (not), -> (implies), <=> (iff)\n  notes: (A <=> B) is translated as ((A -> B) & (B -> A))";
    static final String DEFAULT_MODEL_FILE_NAME = "model.tex";
    private final Class<LSJProver> LSJ_PROVER_CLASS = LSJProver.class;
    private final String LSJ_PROVER_NAME = "lsj";
    private final Class<RJProver> RJ_PROVER_CLASS = RJProver.class;
    private final String RJ_PROVER_NAME = "rj";
    private final AvailableLSJSequentImplementations DEFAULT_SEQUENT_IMPLEMENTATION = LSJProver.DEFAULT_SEQUENT_IMPLEMENTATION;
    private final SelectableSequentsImplementation selectableSequentImplementations;
    private Launcher launcher = new Launcher();
    boolean generateModel = false;
    AvailableLSJSequentImplementations selectedSequentImplementation;

    private Main() {
        this.selectableSequentImplementations = new SelectableSequentsImplementation();
        this.selectableSequentImplementations.setDefault(this.DEFAULT_SEQUENT_IMPLEMENTATION);
    }

    private Options buildCmdLineOptions() {
        MessageManager msg = new MessageManager(this.OPTION_PROPERTIES_BUNDLE_NAME);
        Options options = new Options();
        options.addOption(Option.builder((String)CmdLineOptionsNames.LIST_SEQ_IMPLEMENTATION).hasArg(false).desc(msg.getMsg("LIST_SEQ_IMPLEMENTATION.description")).build());
        options.addOption(Option.builder((String)CmdLineOptionsNames.SEQ_IMPLEMENTATION).hasArg(true).argName("implementation").desc(msg.getMsg("SEQ_IMPLEMENTATION.description", new Object[]{this.selectableSequentImplementations.getNames()})).build());
        options.addOption(Option.builder((String)CmdLineOptionsNames.GENERATE_COUNTER_MODEL).hasArg(false).desc(msg.getMsg("MODEL.description", new Object[]{DEFAULT_MODEL_FILE_NAME})).build());
        return options;
    }

    private void processCommandLineOptions(String[] args) {
        Launcher.LaunchConfiguration currentConfiguration = this.launcher.processCmdLineArguments(args);
        CommandLine commandLine = currentConfiguration.getCommandLine();
        if (commandLine.hasOption(CmdLineOptionsNames.LIST_SEQ_IMPLEMENTATION)) {
            LSJLauncherMessageManager.printlnMsg("available.adts", AvailableLSJSequentImplementations.getDescriptions());
            System.exit(0);
        }
        if (commandLine.hasOption(CmdLineOptionsNames.GENERATE_COUNTER_MODEL)) {
            if (currentConfiguration.getSelectedProver().getName().equals("lsj")) {
                LSJLauncherMessageManager.printlnMsg("option.model.not.applicable", "lsj");
                System.exit(1);
            }
            this.launcher.setTraceGenerationMode(true);
            this.generateModel = true;
        }
        if (commandLine.hasOption(CmdLineOptionsNames.SEQ_IMPLEMENTATION)) {
            String arg = commandLine.getOptionValue(CmdLineOptionsNames.SEQ_IMPLEMENTATION);
            AvailableLSJSequentImplementations impl = this.selectableSequentImplementations.searchByName(arg);
            if (impl == null) {
                LSJLauncherMessageManager.printlnMsg("unknown.sequent.implementation", arg);
                System.exit(1);
            } else {
                this.selectedSequentImplementation = impl;
            }
        } else {
            this.selectedSequentImplementation = this.DEFAULT_SEQUENT_IMPLEMENTATION;
        }
    }

    private void start(String[] args) {
        this.launcher.configLauncherName(this.getClass().getCanonicalName());
        this.launcher.optConfigWelcomeMessage(WELCOME);
        this.launcher.configStandardInputReader(new PlainProblemReader());
        this.launcher.optConfigInputSyntax(FORMULA_SYNTAX_DESCRIPTION);
        this.launcher.optConfigCmdLineOptions(this.buildCmdLineOptions());
        this.launcher.configProblemDescriptionReader("iltp", ILTPProblemReader.class);
        this.launcher.configProblemDescriptionReader("plain", PlainProblemReader.class);
        this.launcher.configProblemDescriptionReader("jtw", JTabWbSimpleProblemReader.class, true);
        this.launcher.configTheoremProver("lsj", this.LSJ_PROVER_CLASS, true);
        this.launcher.configTheoremProver("rj", this.RJ_PROVER_CLASS);
        LSJInitialNodeSetBuilder initialNodeSetBuilder = new LSJInitialNodeSetBuilder();
        this.launcher.configInitialNodeSetBuilder(initialNodeSetBuilder);
        this.processCommandLineOptions(args);
        SingelExecutionConfigurator configurator = new SingelExecutionConfigurator(initialNodeSetBuilder, this.selectedSequentImplementation);
        this.launcher.optConfigSingleExecutionConfigurator(configurator);
        this.launcher.launch();
        ProofSearchData info = this.launcher.getLastProofSearchData();
        if (this.generateModel) {
            Trace trace = info.getTrace();
            if (trace.getStatus() != ProofSearchResult.SUCCESS) {
                LSJLauncherMessageManager.printlnMsg("model.not.success", new Object[0]);
                System.exit(1);
            }
            trace.pruneSuccessful();
            KripkeModel km = KripkeModel.buildFrom(trace);
            try {
                File file = new File(DEFAULT_MODEL_FILE_NAME);
                PrintStream out = new PrintStream(file);
                LSJLauncherMessageManager.printMsg("generating.model", new Object[0]);
                km.toLatex(out);
                LSJLauncherMessageManager.printlnMsg("generating.model.done", file.getAbsolutePath());
            }
            catch (IOException e) {
                LSJLauncherMessageManager.printlnMsg("io.exception", e.getMessage());
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.start(args);
    }

    private static class CmdLineOptionsNames {
        static String SEQ_IMPLEMENTATION = "seq";
        static String LIST_SEQ_IMPLEMENTATION = "lseq";
        static String GENERATE_COUNTER_MODEL = "model";

        private CmdLineOptionsNames() {
        }
    }
}

