/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.launcher;

import ipl.lsj.launcher.ImplementationError;
import ipl.lsj.sequent.AvailableLSJSequentImplementations;
import ipl.lsj.sequent.LSJFormulaFactory;
import ipl.lsj.sequent.LSJSequentOnArray;
import ipl.lsj.sequent.LSJSequentOnBSF;
import ipl.lsj.sequent.LSJSequentOnBitSet;
import ipl.lsj.sequent.LSJSequentOnLists;
import ipl.lsj.sequent._LSJSequent;
import jtabwb.engine._AbstractGoal;
import jtabwb.launcher.InitialGoalBuilderException;
import jtabwb.launcher.ProblemDescription;
import jtabwb.launcher._InitialGoalBuilder;
import jtabwbx.problems.ILTPProblem;
import jtabwbx.problems.JTabWbSimpleProblem;
import jtabwbx.prop.parser.FormulaParseException;
import jtabwbx.prop.parser.PropositionalFormulaParser;

public class LSJInitialNodeSetBuilder
implements _InitialGoalBuilder {
    private AvailableLSJSequentImplementations selectedImplementation;
    private LSJFormulaFactory formulaFactory;

    public void setSequentImplementation(AvailableLSJSequentImplementations selectedImplementation) {
        this.selectedImplementation = selectedImplementation;
    }

    public void setFormulaFactory(LSJFormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
    }

    @Override
    public _AbstractGoal buildInitialNodeSet(ProblemDescription inputProblem) throws InitialGoalBuilderException {
        if (inputProblem instanceof JTabWbSimpleProblem) {
            return this.buildFrom((JTabWbSimpleProblem)inputProblem);
        }
        if (inputProblem instanceof ILTPProblem) {
            return this.buildFrom((ILTPProblem)inputProblem);
        }
        throw new ImplementationError("Unkonw problem description.", new String[0]);
    }

    private _LSJSequent getEmptyNodeSet(AvailableLSJSequentImplementations seqImpl, LSJFormulaFactory factory) {
        Cloneable nodeSet = null;
        switch (seqImpl) {
            case SEQ_ARRAY: {
                nodeSet = new LSJSequentOnArray(factory);
                break;
            }
            case SEQ_LIST: {
                nodeSet = new LSJSequentOnLists(factory);
                break;
            }
            case SEQ_BITSET: {
                nodeSet = new LSJSequentOnBitSet(factory);
                break;
            }
            case SEQ_BSF: {
                nodeSet = new LSJSequentOnBSF(factory);
                break;
            }
            default: {
                throw new ImplementationError();
            }
        }
        return nodeSet;
    }

    private _LSJSequent buildFrom(JTabWbSimpleProblem inputProblem) throws InitialGoalBuilderException {
        PropositionalFormulaParser parser = new PropositionalFormulaParser();
        String conjecture = inputProblem.getConjecture();
        if (conjecture == null) {
            throw new InitialGoalBuilderException("No problem formula defined in the input problem.");
        }
        _LSJSequent nodeSet = this.getEmptyNodeSet(this.selectedImplementation, this.formulaFactory);
        try {
            nodeSet.addRight(this.formulaFactory.buildFrom(parser.parse(conjecture)));
        }
        catch (FormulaParseException e) {
            throw new InitialGoalBuilderException(e.getMessage());
        }
        return nodeSet;
    }

    private _LSJSequent buildFrom(ILTPProblem inputProblem) throws InitialGoalBuilderException {
        PropositionalFormulaParser parser = new PropositionalFormulaParser();
        String conjecture = inputProblem.getConjecture();
        if (conjecture == null) {
            throw new InitialGoalBuilderException("No problem formula defined in the input problem.");
        }
        _LSJSequent nodeSet = this.getEmptyNodeSet(this.selectedImplementation, this.formulaFactory);
        try {
            nodeSet.addRight(this.formulaFactory.buildFrom(parser.parse(conjecture)));
            if (inputProblem.getAxioms() != null) {
                for (String axiom : inputProblem.getAxioms()) {
                    nodeSet.addLeft(this.formulaFactory.buildFrom(parser.parse(axiom)));
                }
            }
        }
        catch (FormulaParseException e) {
            throw new InitialGoalBuilderException(e.getMessage());
        }
        return nodeSet;
    }
}

