/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.launcher;

import ipl.lsj.launcher.ImplementationError;
import ipl.lsj.launcher.KripkeModelLatexGenerator;
import ipl.lsj.sequent._LSJSequent;
import ipl.rj.calculus.RJRuleIdentifier;
import ipl.rj.calculus._RJAbstractRule;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import jtabwb.engine.Trace;
import jtabwb.engine.TraceNode;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic._PropositionalFormula;
import jtabwbx.prop.formula.Formula;

public class KripkeModel {
    private String INDENTATION = "  ";
    private int name;
    private LinkedList<KripkeModel> successors;
    private LinkedList<_PropositionalFormula> forcedPropositions;
    static int nodeCounter = 0;

    public KripkeModel(int name) {
        this.name = name;
        this.successors = null;
        this.forcedPropositions = null;
    }

    public void addSuccessor(KripkeModel successor) {
        if (this.successors == null) {
            this.successors = new LinkedList();
        }
        this.successors.addLast(successor);
    }

    public void addForcedPropositionalVariables(Collection<Formula> propositions) {
        if (propositions == null || propositions.size() == 0) {
            return;
        }
        if (this.forcedPropositions == null) {
            this.forcedPropositions = new LinkedList();
        }
        for (_PropositionalFormula _PropositionalFormula2 : propositions) {
            this.forcedPropositions.addLast((Formula)_PropositionalFormula2);
        }
    }

    public int getName() {
        return this.name;
    }

    public LinkedList<KripkeModel> getSuccessors() {
        return this.successors;
    }

    public LinkedList<_PropositionalFormula> getForcedPropositions() {
        return this.forcedPropositions;
    }

    public String toString() {
        return this.toStringIndent("");
    }

    private String toStringIndent(String indent) {
        String str = String.valueOf(indent) + "[" + this.name + "]: " + this.forcing() + "\n";
        if (this.successors == null) {
            return str;
        }
        indent = String.valueOf(indent) + this.INDENTATION;
        for (KripkeModel succ : this.successors) {
            str = String.valueOf(str) + succ.toStringIndent(indent);
        }
        return str;
    }

    private String forcing() {
        if (this.forcedPropositions == null) {
            return "";
        }
        Formula[] a = this.forcedPropositions.toArray(new Formula[this.forcedPropositions.size()]);
        String str = "";
        int i = 0;
        while (i < a.length) {
            str = String.valueOf(str) + a[i].toString() + (i < a.length - 1 ? ", " : "");
            ++i;
        }
        return str;
    }

    static KripkeModel buildFrom(Trace trace) {
        TraceNode traceHead = trace.getProofSearchTree();
        LinkedList<KripkeModel> setOfKrikeModels = KripkeModel._build(traceHead);
        if (setOfKrikeModels.size() != 1) {
            throw new ImplementationError();
        }
        return setOfKrikeModels.getFirst();
    }

    private static LinkedList<KripkeModel> _build(TraceNode node) {
        _LSJSequent premise = (_LSJSequent)node.getPremise();
        _RJAbstractRule appliedRule = (_RJAbstractRule)node.getAppliedRule();
        RJRuleIdentifier ruleId = appliedRule.getRuleIdentifier();
        switch (ruleId) {
            case CLASH_DETECTION: {
                KripkeModel kw = new KripkeModel(nodeCounter++);
                kw.addForcedPropositionalVariables(premise.getLeftFormulas(FormulaType.ATOMIC_WFF));
                LinkedList<KripkeModel> list = new LinkedList<KripkeModel>();
                list.add(kw);
                return list;
            }
            case LEFT_AND: 
            case LEFT_OR: 
            case LEFT_IMPLIES: 
            case LEFT_NOT: 
            case RIGHT_AND: 
            case RIGHT_OR: 
            case RIGHT_IMPLIES: 
            case RIGHT_NOT: {
                LinkedList<TraceNode> successors = node.getChildren();
                if (successors.size() != 1) {
                    throw new ImplementationError();
                }
                return KripkeModel._build(successors.getFirst());
            }
            case RULE_SUCC: {
                KripkeModel kw = new KripkeModel(nodeCounter++);
                LinkedList<KripkeModel> submodels = new LinkedList<KripkeModel>();
                LinkedList<TraceNode> successors = node.getChildren();
                for (TraceNode s : successors) {
                    LinkedList<KripkeModel> childModels = KripkeModel._build(s);
                    if (childModels == null) continue;
                    submodels.addAll(childModels);
                }
                if (submodels.size() > 0) {
                    for (KripkeModel submodel : submodels) {
                        kw.addSuccessor(submodel);
                    }
                }
                kw.addForcedPropositionalVariables(premise.getLeftFormulas(FormulaType.ATOMIC_WFF));
                LinkedList<KripkeModel> list = new LinkedList<KripkeModel>();
                list.add(kw);
                return list;
            }
        }
        throw new ImplementationError();
    }

    public void toLatex(PrintStream out) {
        KripkeModelLatexGenerator lg = new KripkeModelLatexGenerator(this);
        lg.generateLatex(out);
    }
}

