/*
 * Decompiled with CFR 0.152.
 */
package ipl.lsj.calculus;

import ipl.lsj.calculus.ImplementationError;
import ipl.lsj.calculus.LSJClashDetectionRule;
import ipl.lsj.calculus.LSJRuleIdentifiers;
import ipl.lsj.calculus.Rule_Left_And;
import ipl.lsj.calculus.Rule_Left_Implies;
import ipl.lsj.calculus.Rule_Left_Implies_CL;
import ipl.lsj.calculus.Rule_Left_Implies_REDUCED;
import ipl.lsj.calculus.Rule_Left_Not;
import ipl.lsj.calculus.Rule_Left_Not_CL;
import ipl.lsj.calculus.Rule_Left_Not_REDUCED;
import ipl.lsj.calculus.Rule_Left_Or;
import ipl.lsj.calculus.Rule_Right_And;
import ipl.lsj.calculus.Rule_Right_Implies;
import ipl.lsj.calculus.Rule_Right_Implies_CL;
import ipl.lsj.calculus.Rule_Right_Implies_REDUCED;
import ipl.lsj.calculus.Rule_Right_Not;
import ipl.lsj.calculus.Rule_Right_Not_CL;
import ipl.lsj.calculus.Rule_Right_Or;
import ipl.lsj.calculus._LSJAbstractRule;
import ipl.lsj.sequent._LSJSequent;
import java.util.EnumSet;
import jtabwb.engine._AbstractRule;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;

public class LSJCalculus {
    public static final EnumSet<FormulaType> LEFT_NON_INVERTIBLE = EnumSet.of(FormulaType.IMPLIES_WFF, FormulaType.NOT_WFF);
    public static final EnumSet<FormulaType> RIGHT_NON_INVERTIBLE = EnumSet.of(FormulaType.IMPLIES_WFF, FormulaType.NOT_WFF);

    private _LSJAbstractRule getRule(LSJRuleIdentifiers ruleId, _LSJSequent goal, Formula mainFormula) {
        switch (ruleId) {
            case CLASH_DETECTION: {
                return new LSJClashDetectionRule(goal);
            }
            case LEFT_AND: {
                return new Rule_Left_And(goal, mainFormula);
            }
            case RIGHT_AND: {
                return new Rule_Right_And(goal, mainFormula);
            }
            case LEFT_OR: {
                return new Rule_Left_Or(goal, mainFormula);
            }
            case RIGHT_OR: {
                return new Rule_Right_Or(goal, mainFormula);
            }
            case LEFT_IMPLIES: {
                return new Rule_Left_Implies(goal, mainFormula);
            }
            case LEFT_IMPLIES_CL: {
                return new Rule_Left_Implies_CL(goal, mainFormula);
            }
            case LEFT_IMPLIES_REDUCED: {
                return new Rule_Left_Implies_REDUCED(goal, mainFormula);
            }
            case RIGHT_IMPLIES: {
                return new Rule_Right_Implies(goal, mainFormula);
            }
            case RIGHT_IMPLIES_CL: {
                return new Rule_Right_Implies_CL(goal, mainFormula);
            }
            case RIGHT_IMPLIES_REDUCED: {
                return new Rule_Right_Implies_REDUCED(goal, mainFormula);
            }
            case LEFT_NOT: {
                return new Rule_Left_Not(goal, mainFormula);
            }
            case LEFT_NOT_CL: {
                return new Rule_Left_Not_CL(goal, mainFormula);
            }
            case LEFT_NOT_REDUCED: {
                return new Rule_Left_Not_REDUCED(goal, mainFormula);
            }
            case RIGHT_NOT: {
                return new Rule_Right_Not(goal, mainFormula);
            }
            case RIGHT_NOT_CL: {
                return new Rule_Right_Not_CL(goal, mainFormula);
            }
            case RIGHT_NOT_REDUCED: {
                return new Rule_Right_Not_CL(goal, mainFormula);
            }
        }
        throw new ImplementationError();
    }

    public _AbstractRule getRuleByName(String name, _LSJSequent premise, Formula mainFormula) {
        LSJRuleIdentifiers ruleId = LSJRuleIdentifiers.getByName(name);
        if (ruleId == null) {
            return null;
        }
        return this.getRule(ruleId, premise, mainFormula);
    }
}

