/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaSetOnList;
import jtabwbx.prop.formula._Sequent;

public class SequentOnLists
implements _Sequent,
Cloneable {
    private FormulaSetOnList[] left = new FormulaSetOnList[FormulaType.values().length];
    private FormulaSetOnList[] right = new FormulaSetOnList[FormulaType.values().length];

    @Override
    public Collection<Formula> getLeftFormulas() {
        FormulaSetOnList set = new FormulaSetOnList();
        FormulaSetOnList[] formulaSetOnListArray = this.left;
        int n = this.left.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaSetOnList s = formulaSetOnListArray[n2];
            if (s != null) {
                set.addAll(s);
            }
            ++n2;
        }
        if (set.cardinality() == 0) {
            return null;
        }
        return set.getAllFormulas();
    }

    @Override
    public Collection<Formula> getLeftFormulas(FormulaType formulaType) {
        int setIndex = formulaType.ordinal();
        if (this.left[setIndex] == null) {
            return null;
        }
        return this.left[setIndex].getAllFormulas();
    }

    @Override
    public Collection<Formula> getRightFormulas() {
        FormulaSetOnList set = new FormulaSetOnList();
        FormulaSetOnList[] formulaSetOnListArray = this.right;
        int n = this.right.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaSetOnList s = formulaSetOnListArray[n2];
            if (s != null) {
                set.addAll(s);
            }
            ++n2;
        }
        if (set.cardinality() == 0) {
            return null;
        }
        return set.getAllFormulas();
    }

    @Override
    public Collection<Formula> getRightFormulas(FormulaType formulaType) {
        int setIndex = formulaType.ordinal();
        if (this.right[setIndex] == null) {
            return null;
        }
        return this.right[setIndex].getAllFormulas();
    }

    @Override
    public void addLeft(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        if (this.left[index] == null) {
            this.left[index] = new FormulaSetOnList();
            this.left[index].add(wff);
        } else {
            this.left[index].add(wff);
        }
    }

    @Override
    public void addRight(Formula wff) {
        int index = FormulaType.getFormulaType(wff).ordinal();
        if (this.right[index] == null) {
            this.right[index] = new FormulaSetOnList();
            this.right[index].add(wff);
        } else {
            this.right[index].add(wff);
        }
    }

    private Formula getLeftFormula(int index) {
        if (this.left[index] != null) {
            return this.left[index].getFirst();
        }
        return null;
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        return this.getLeftFormula(formulaType.ordinal());
    }

    private Formula getRightFormula(int index) {
        if (this.right[index] != null) {
            return this.right[index].getFirst();
        }
        return null;
    }

    @Override
    public Formula getRight(FormulaType formulaType) {
        return this.getRightFormula(formulaType.ordinal());
    }

    @Override
    public boolean isRightSideEmpty() {
        FormulaSetOnList[] formulaSetOnListArray = this.right;
        int n = this.right.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaSetOnList set = formulaSetOnListArray[n2];
            if (set != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isLeftSideEmpty() {
        FormulaSetOnList[] formulaSetOnListArray = this.left;
        int n = this.left.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaSetOnList set = formulaSetOnListArray[n2];
            if (set != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.isLeftSideEmpty() && this.isLeftSideEmpty();
    }

    @Override
    public boolean removeLeft(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        if (this.left[index] != null) {
            boolean result = this.left[index].remove(wff);
            if (this.left[index].cardinality() == 0) {
                this.left[index] = null;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean removeRight(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        if (this.right[index] != null) {
            boolean result = this.right[index].remove(wff);
            if (this.right[index].cardinality() == 0) {
                this.right[index] = null;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean isIdentityAxiom() {
        FormulaType[] formulaTypeArray = FormulaType.values();
        int n = formulaTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaType type = formulaTypeArray[n2];
            int index = type.ordinal();
            if (this.left[index] != null && this.right[index] != null) {
                for (Formula rw : this.right[index]) {
                    if (!this.left[index].contains(rw)) continue;
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean containsLeft(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        return this.left[index] != null && this.left[index].contains(wff);
    }

    @Override
    public boolean containsLeft(FormulaType type) {
        return this.left[type.ordinal()] != null;
    }

    @Override
    public boolean containsRight(Formula wff) {
        FormulaType type = FormulaType.getFormulaType(wff);
        int index = type.ordinal();
        return this.right[index] != null && this.right[index].contains(wff);
    }

    @Override
    public boolean containsRight(FormulaType type) {
        return this.right[type.ordinal()] != null;
    }

    @Override
    public SequentOnLists clone() {
        try {
            SequentOnLists cloned = (SequentOnLists)super.clone();
            cloned.left = new FormulaSetOnList[FormulaType.values().length];
            int i = 0;
            while (i < this.left.length) {
                if (this.left[i] != null) {
                    cloned.left[i] = this.left[i].clone();
                }
                ++i;
            }
            cloned.right = new FormulaSetOnList[FormulaType.values().length];
            i = 0;
            while (i < this.right.length) {
                if (this.right[i] != null) {
                    cloned.right[i] = this.right[i].clone();
                }
                ++i;
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError("Clone not supported: " + e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequentOnLists other = (SequentOnLists)obj;
        return Arrays.equals(this.left, other.left) && Arrays.equals(this.right, other.right);
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        String lstr = "";
        int i = 0;
        while (i < FormulaType.values().length) {
            if (this.left[i] != null) {
                lstr = String.valueOf(lstr) + this.left[i].toString();
            }
            ++i;
        }
        String rstr = "";
        int i2 = 0;
        while (i2 < FormulaType.values().length) {
            if (this.right[i2] != null) {
                rstr = String.valueOf(rstr) + this.right[i2].toString();
            }
            ++i2;
        }
        return String.valueOf(lstr) + "==>\n" + rstr;
    }

    @Override
    public void stablePart() {
        this.clearRight();
    }

    @Override
    public void clearLeft() {
        int i = 0;
        while (i < this.left.length) {
            this.left[i] = null;
            ++i;
        }
    }

    @Override
    public void clearRight() {
        int i = 0;
        while (i < this.right.length) {
            this.right[i] = null;
            ++i;
        }
    }

    @Override
    public void addLeft(Collection<Formula> formulas) {
        for (Formula formula : formulas) {
            this.addRight(formula);
        }
    }

    @Override
    public void addRight(Collection<Formula> formulas) {
        for (Formula formula : formulas) {
            this.addRight(formula);
        }
    }

    @Override
    public Iterator<Formula> leftSideIterator() {
        return this.getLeftFormulas().iterator();
    }

    @Override
    public Iterator<Formula> rigtSideIterator() {
        return this.getRightFormulas().iterator();
    }
}

