/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula._Sequent;

public class SequentOnBitSet
implements _Sequent,
Cloneable {
    private static int NUMBER_OF_FORMULA_TYPE = FormulaType.values().length;
    private FormulaFactory factory;
    private BitSet leftside;
    private BitSet rightside;
    private LinkedList<Formula>[] leftFormulas;
    private LinkedList<Formula>[] rightFormulas;

    public SequentOnBitSet(FormulaFactory factory) {
        this.factory = factory;
        this.leftside = new BitSet(factory.numberOfGeneratedFormulas());
        this.rightside = new BitSet(factory.numberOfGeneratedFormulas());
        this.leftFormulas = new LinkedList[NUMBER_OF_FORMULA_TYPE];
        this.rightFormulas = new LinkedList[NUMBER_OF_FORMULA_TYPE];
    }

    @Override
    public Collection<Formula> getLeftFormulas() {
        LinkedList<Formula> coll = new LinkedList<Formula>();
        LinkedList<Formula>[] linkedListArray = this.leftFormulas;
        int n = this.leftFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            LinkedList<Formula> set = linkedListArray[n2];
            if (set != null) {
                coll.addAll(set);
            }
            ++n2;
        }
        return coll.size() == 0 ? null : coll;
    }

    @Override
    public Collection<Formula> getLeftFormulas(FormulaType formulaType) {
        return this.leftFormulas[formulaType.ordinal()];
    }

    @Override
    public Collection<Formula> getRightFormulas() {
        LinkedList<Formula> coll = new LinkedList<Formula>();
        LinkedList<Formula>[] linkedListArray = this.rightFormulas;
        int n = this.rightFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            LinkedList<Formula> set = linkedListArray[n2];
            if (set != null) {
                coll.addAll(set);
            }
            ++n2;
        }
        return coll.size() == 0 ? null : coll;
    }

    @Override
    public Collection<Formula> getRightFormulas(FormulaType formulaType) {
        return this.rightFormulas[formulaType.ordinal()];
    }

    @Override
    public void addLeft(Formula wff) {
        int idx = wff.getIndex();
        if (!this.leftside.get(idx)) {
            this.leftside.set(idx);
            int type_idx = wff.getFormulaType().ordinal();
            if (this.leftFormulas[type_idx] == null) {
                this.leftFormulas[type_idx] = new LinkedList();
            }
            this.leftFormulas[type_idx].add(wff);
        }
    }

    @Override
    public void addRight(Formula wff) {
        int idx = wff.getIndex();
        if (!this.rightside.get(idx)) {
            this.rightside.set(idx);
            int type_idx = wff.getFormulaType().ordinal();
            if (this.rightFormulas[type_idx] == null) {
                this.rightFormulas[type_idx] = new LinkedList();
            }
            this.rightFormulas[type_idx].add(wff);
        }
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        LinkedList<Formula> list = this.leftFormulas[formulaType.ordinal()];
        return list == null ? null : list.getFirst();
    }

    @Override
    public Formula getRight(FormulaType formulaType) {
        LinkedList<Formula> list = this.rightFormulas[formulaType.ordinal()];
        return list == null ? null : list.getFirst();
    }

    @Override
    public boolean removeLeft(Formula wff) {
        int idx = wff.getIndex();
        if (this.leftside.get(idx)) {
            this.leftside.set(idx, false);
            int type_idx = wff.getFormulaType().ordinal();
            LinkedList<Formula> list = this.leftFormulas[type_idx];
            list.remove(wff);
            if (list.size() == 0) {
                this.leftFormulas[type_idx] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRight(Formula wff) {
        int idx = wff.getIndex();
        if (this.rightside.get(idx)) {
            this.rightside.set(idx, false);
            int type_idx = wff.getFormulaType().ordinal();
            LinkedList<Formula> list = this.rightFormulas[type_idx];
            list.remove(wff);
            if (list.size() == 0) {
                this.rightFormulas[type_idx] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isIdentityAxiom() {
        return this.leftside.intersects(this.rightside);
    }

    @Override
    public boolean containsLeft(Formula wff) {
        return this.leftside.get(wff.getIndex());
    }

    @Override
    public boolean containsLeft(FormulaType type) {
        return this.leftFormulas[type.ordinal()] != null;
    }

    @Override
    public boolean containsRight(Formula wff) {
        return this.rightside.get(wff.getIndex());
    }

    @Override
    public boolean containsRight(FormulaType type) {
        return this.rightFormulas[type.ordinal()] != null;
    }

    @Override
    public boolean isLeftSideEmpty() {
        return this.leftside.isEmpty();
    }

    @Override
    public boolean isRightSideEmpty() {
        return this.rightside.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.leftside.isEmpty() && this.rightside.isEmpty();
    }

    @Override
    public SequentOnBitSet clone() {
        try {
            SequentOnBitSet cloned = (SequentOnBitSet)super.clone();
            cloned.leftside = (BitSet)this.leftside.clone();
            cloned.rightside = (BitSet)this.rightside.clone();
            cloned.leftFormulas = new LinkedList[FormulaType.values().length];
            cloned.rightFormulas = new LinkedList[FormulaType.values().length];
            int i = 0;
            while (i < this.leftFormulas.length) {
                if (this.leftFormulas[i] != null) {
                    cloned.leftFormulas[i] = (LinkedList)this.leftFormulas[i].clone();
                }
                ++i;
            }
            i = 0;
            while (i < this.rightFormulas.length) {
                if (this.rightFormulas[i] != null) {
                    cloned.rightFormulas[i] = (LinkedList)this.rightFormulas[i].clone();
                }
                ++i;
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError("Clone not supported: " + e.getMessage());
        }
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        return String.valueOf(this.toString(this.getLeftFormulas())) + "==>\n" + this.toString(this.getRightFormulas());
    }

    private String toString(Collection<Formula> list) {
        if (list == null) {
            return "";
        }
        Iterator<Formula> it = list.iterator();
        String str = it.next().format();
        while (it.hasNext()) {
            str = String.valueOf(str) + ", " + it.next().format();
        }
        return str;
    }

    @Override
    public void stablePart() {
        this.clearRight();
    }

    @Override
    public void clearLeft() {
        this.leftside.clear();
        int i = 0;
        while (i < this.leftFormulas.length) {
            this.leftFormulas[i] = null;
            ++i;
        }
    }

    @Override
    public void clearRight() {
        this.rightside.clear();
        int i = 0;
        while (i < this.rightFormulas.length) {
            this.rightFormulas[i] = null;
            ++i;
        }
    }

    @Override
    public void addLeft(Collection<Formula> formulas) {
        for (Formula formula : formulas) {
            this.addLeft(formula);
        }
    }

    @Override
    public void addRight(Collection<Formula> formulas) {
        for (Formula formula : formulas) {
            this.addRight(formula);
        }
    }

    public FormulaFactory getFormulaFactory() {
        return this.factory;
    }

    @Override
    public Iterator<Formula> leftSideIterator() {
        return this.getLeftFormulas().iterator();
    }

    @Override
    public Iterator<Formula> rigtSideIterator() {
        return this.getRightFormulas().iterator();
    }
}

