/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Collection;
import java.util.Iterator;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula._Sequent;

public class SequentOnBSFWithFormulasByType
implements _Sequent,
Cloneable {
    private FormulaFactory formulaFactory;
    private BitSetOfFormulas leftside;
    private BitSetOfFormulas rightside;
    private BitSetOfFormulas[] leftFormulas;
    private BitSetOfFormulas[] rightFormulas;

    public SequentOnBSFWithFormulasByType(FormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
        this.leftside = new BitSetOfFormulas(formulaFactory);
        this.rightside = new BitSetOfFormulas(formulaFactory);
        this.leftFormulas = new BitSetOfFormulas[FormulaType.values().length];
        this.rightFormulas = new BitSetOfFormulas[FormulaType.values().length];
    }

    @Override
    public void addLeft(Formula wff) {
        int idx = wff.getIndex();
        if (!this.leftside.get(idx)) {
            this.leftside.set(idx);
            int type_idx = FormulaType.getFormulaType(wff).ordinal();
            if (this.leftFormulas[type_idx] == null) {
                this.leftFormulas[type_idx] = new BitSetOfFormulas(this.formulaFactory);
            }
            this.leftFormulas[type_idx].add(wff);
        }
    }

    @Override
    public void addLeft(Collection<Formula> formulas) {
        for (Formula formula : formulas) {
            this.addLeft(formula);
        }
    }

    public void addLeft(BitSetOfFormulas formulas) {
        for (Formula formula : formulas) {
            this.addLeft(formula);
        }
    }

    @Override
    public void addRight(Formula wff) {
        int idx = wff.getIndex();
        if (!this.rightside.get(idx)) {
            this.rightside.set(idx);
            int type_idx = FormulaType.getFormulaType(wff).ordinal();
            if (this.rightFormulas[type_idx] == null) {
                this.rightFormulas[type_idx] = new BitSetOfFormulas(this.formulaFactory);
            }
            this.rightFormulas[type_idx].add(wff);
        }
    }

    @Override
    public void addRight(Collection<Formula> formulas) {
        for (Formula formula : formulas) {
            this.addRight(formula);
        }
    }

    public void addRight(BitSetOfFormulas formulas) {
        for (Formula formula : formulas) {
            this.addRight(formula);
        }
    }

    @Override
    public void clearLeft() {
        this.leftside.clear();
    }

    @Override
    public void clearRight() {
        this.rightside.clear();
        int i = 0;
        while (i < this.rightFormulas.length) {
            this.rightFormulas[i] = null;
            ++i;
        }
    }

    @Override
    public SequentOnBSFWithFormulasByType clone() {
        try {
            SequentOnBSFWithFormulasByType result = (SequentOnBSFWithFormulasByType)super.clone();
            result.formulaFactory = this.formulaFactory;
            result.leftside = this.leftside.clone();
            result.rightside = this.rightside.clone();
            result.leftFormulas = new BitSetOfFormulas[FormulaType.values().length];
            int i = 0;
            while (i < this.leftFormulas.length) {
                if (this.leftFormulas[i] != null) {
                    result.leftFormulas[i] = this.leftFormulas[i].clone();
                }
                ++i;
            }
            result.rightFormulas = new BitSetOfFormulas[FormulaType.values().length];
            i = 0;
            while (i < this.rightFormulas.length) {
                if (this.rightFormulas[i] != null) {
                    result.rightFormulas[i] = this.rightFormulas[i].clone();
                }
                ++i;
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError(e.getMessage());
        }
    }

    @Override
    public boolean containsLeft(Formula wff) {
        return this.leftside.contains(wff);
    }

    @Override
    public boolean containsLeft(FormulaType type) {
        return this.leftFormulas[type.ordinal()] != null;
    }

    @Override
    public boolean containsRight(Formula wff) {
        return this.rightside.contains(wff);
    }

    @Override
    public boolean containsRight(FormulaType type) {
        return this.rightFormulas[type.ordinal()] != null;
    }

    @Override
    public String format() {
        return this.toString();
    }

    public FormulaFactory getFormulaFactory() {
        return this.formulaFactory;
    }

    @Override
    public Collection<Formula> getLeftFormulas() {
        return this.leftside.getAllFormulas();
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        if (this.leftFormulas[formulaType.ordinal()] == null) {
            return null;
        }
        return this.leftFormulas[formulaType.ordinal()].getFirst();
    }

    @Override
    public Collection<Formula> getLeftFormulas(FormulaType formulaType) {
        if (this.leftFormulas[formulaType.ordinal()] == null) {
            return null;
        }
        return this.leftFormulas[formulaType.ordinal()].getAllFormulas(formulaType);
    }

    @Override
    public Formula getRight(FormulaType formulaType) {
        if (this.rightFormulas[formulaType.ordinal()] == null) {
            return null;
        }
        return this.rightFormulas[formulaType.ordinal()].getFirst();
    }

    @Override
    public Collection<Formula> getRightFormulas() {
        return this.rightside.getAllFormulas();
    }

    @Override
    public Collection<Formula> getRightFormulas(FormulaType formulaType) {
        if (this.rightFormulas[formulaType.ordinal()] == null) {
            return null;
        }
        return this.rightFormulas[formulaType.ordinal()].getAllFormulas(formulaType);
    }

    @Override
    public boolean isIdentityAxiom() {
        return this.leftside.intersects(this.rightside);
    }

    @Override
    public boolean isLeftSideEmpty() {
        return this.leftside.isEmpty();
    }

    @Override
    public boolean isRightSideEmpty() {
        return this.rightside.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return this.leftside.isEmpty() && this.rightside.isEmpty();
    }

    public BitSetOfFormulas leftSide() {
        return this.leftside.clone();
    }

    public int leftSideCardinality() {
        return this.leftside.cardinality();
    }

    @Override
    public Iterator<Formula> leftSideIterator() {
        return this.leftside.iterator();
    }

    public BitSetOfFormulas rightSide() {
        return this.rightside.clone();
    }

    public int rigthSideCardinality() {
        return this.rightside.cardinality();
    }

    @Override
    public Iterator<Formula> rigtSideIterator() {
        return this.rightside.iterator();
    }

    @Override
    public boolean removeLeft(Formula wff) {
        int idx = wff.getIndex();
        if (this.leftside.get(idx)) {
            this.leftside.set(idx, false);
            int type_idx = wff.getFormulaType().ordinal();
            BitSetOfFormulas set = this.leftFormulas[type_idx];
            set.remove(wff);
            if (set.cardinality() == 0) {
                this.leftFormulas[type_idx] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRight(Formula wff) {
        int idx = wff.getIndex();
        if (this.rightside.get(idx)) {
            this.rightside.set(idx, false);
            int type_idx = wff.getFormulaType().ordinal();
            BitSetOfFormulas set = this.rightFormulas[type_idx];
            set.remove(wff);
            if (set.cardinality() == 0) {
                this.rightFormulas[type_idx] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public void stablePart() {
        this.clearRight();
    }

    public String toString() {
        return String.valueOf(this.toString(this.getLeftFormulas())) + "==>\n" + this.toString(this.getRightFormulas());
    }

    private String toString(Collection<Formula> list) {
        if (list == null) {
            return "";
        }
        Iterator<Formula> it = list.iterator();
        String str = it.next().format();
        while (it.hasNext()) {
            str = String.valueOf(str) + ", " + it.next().format();
        }
        return str;
    }
}

