/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.AbstractCompoundFormula;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.Substitution;

final class FormulaImplies
extends AbstractCompoundFormula {
    protected FormulaImplies(FormulaFactory formulaFactory, Formula left, Formula right) {
        super(formulaFactory, PropositionalConnective.IMPLIES, new Formula[]{left, right}, left, right);
    }

    @Override
    protected int computeHashCode(Formula[] subFormulas) {
        int result = this.mainConnective().hashCode();
        int leftHash = this.subFormulas[0].hashCode();
        int rightHash = this.subFormulas[1].hashCode();
        result = 31 * result + leftHash;
        result = 31 * result + rightHash;
        return result;
    }

    @Override
    protected Formula computeBooleanSimplification() {
        Formula newRight;
        Formula newLeft = this.left.calculateBooleanSimplification();
        if (newLeft.equals(newRight = this.right.calculateBooleanSimplification())) {
            return this.formulaFactory.getTrue();
        }
        if (newLeft.isTrue()) {
            return newRight;
        }
        if (newLeft.isFalse()) {
            return this.formulaFactory.getTrue();
        }
        if (newRight.isTrue()) {
            return newRight;
        }
        if (newRight.isFalse() && this.formulaFactory.translateNot) {
            return this.formulaFactory.buildCompound(PropositionalConnective.NOT, newLeft);
        }
        return this.formulaFactory.buildCompound(this.mainConnective(), newLeft, newRight);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormulaImplies that = (FormulaImplies)o;
        return this.left == that.left && this.right == that.right;
    }

    @Override
    protected Formula computePartialSubstitution(Substitution subst) {
        return this;
    }

    @Override
    public FormulaType getFormulaType() {
        return FormulaType.IMPLIES_WFF;
    }
}

