/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.AbstractCompoundFormula;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.Substitution;

class FormulaAnd
extends AbstractCompoundFormula {
    protected FormulaAnd(FormulaFactory formulaFactory, Formula left, Formula right) {
        super(formulaFactory, PropositionalConnective.AND, new Formula[]{left, right}, left, right);
    }

    @Override
    Formula computeBooleanSimplification() {
        Formula newRight;
        Formula newLeft = this.left.calculateBooleanSimplification();
        if (newLeft.equals(newRight = this.right.calculateBooleanSimplification())) {
            return newLeft;
        }
        if (newLeft.isTrue()) {
            return newRight;
        }
        if (newLeft.isFalse()) {
            return newLeft;
        }
        if (newRight.isTrue()) {
            return newLeft;
        }
        if (newRight.isFalse()) {
            return newRight;
        }
        return this.formulaFactory.buildCompound(this.mainConnective(), newLeft, newRight);
    }

    @Override
    protected Formula computePartialSubstitution(Substitution subst) {
        return this.formulaFactory.buildCompound(this.mainConnective(), this.left.applyIntuitionisticPartialSubstitution(subst), this.right.applyIntuitionisticPartialSubstitution(subst));
    }

    @Override
    public FormulaType getFormulaType() {
        return FormulaType.AND_WFF;
    }
}

