/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.btformula;

import java.util.Stack;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.btformula.BTFormula;
import jtabwbx.prop.btformula.BTFormulaCompound;
import jtabwbx.prop.btformula.BTFormulaProposition;
import jtabwbx.prop.btformula.ImplementationError;
import jtabwbx.prop.parser.FormulaBaseListener;
import jtabwbx.prop.parser.FormulaParser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

class BTFormulaBuilder
extends FormulaBaseListener {
    private Stack<BTFormula> stack;

    BTFormulaBuilder() {
    }

    BTFormula buildFrom(ParseTree tree) {
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)this, tree);
        if (this.stack.size() == 1) {
            BTFormula wff = this.stack.pop();
            this.stack = null;
            return wff;
        }
        throw new ImplementationError();
    }

    @Override
    public void enterFormula(FormulaParser.FormulaContext ctx) {
        this.stack = new Stack();
    }

    @Override
    public void exitProp(FormulaParser.PropContext ctx) {
        this.stack.push(new BTFormulaProposition(ctx.getText()));
    }

    @Override
    public void exitAnd(FormulaParser.AndContext ctx) {
        BTFormula right = this.stack.pop();
        BTFormula left = this.stack.pop();
        this.stack.push(new BTFormulaCompound(PropositionalConnective.AND, left, right));
    }

    @Override
    public void exitOr(FormulaParser.OrContext ctx) {
        BTFormula right = this.stack.pop();
        BTFormula left = this.stack.pop();
        this.stack.push(new BTFormulaCompound(PropositionalConnective.OR, left, right));
    }

    @Override
    public void exitImp(FormulaParser.ImpContext ctx) {
        BTFormula right = this.stack.pop();
        BTFormula left = this.stack.pop();
        this.stack.push(new BTFormulaCompound(PropositionalConnective.IMPLIES, left, right));
    }

    @Override
    public void exitEq(FormulaParser.EqContext ctx) {
        BTFormula right = this.stack.pop();
        BTFormula left = this.stack.pop();
        this.stack.push(new BTFormulaCompound(PropositionalConnective.EQ, left, right));
    }

    @Override
    public void exitNeg(FormulaParser.NegContext ctx) {
        this.stack.push(new BTFormulaCompound(PropositionalConnective.NOT, this.stack.pop()));
    }

    @Override
    public void exitPar(FormulaParser.ParContext ctx) {
    }
}

