/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.problems;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.launcher.ProblemDescriptionException;
import jtabwb.launcher._ProblemReader;
import jtabwbx.problems.JTabWbSimpleProblem;

public class JTabWbSimpleProblemReader
implements _ProblemReader {
    public static final String NAME = "jtawb_fromat";
    private static final String DESCRIPTION = "The file describes a problem according with simple JTabWb format";
    private final String PRE_NAME = "% File     :";
    private final String PRE_STATUS = "% Status   :";

    @Override
    public JTabWbSimpleProblem read(Reader input) throws ProblemDescriptionException, IOException {
        BufferedReader reader = new BufferedReader(input);
        String name = null;
        String status = null;
        String formula = null;
        reader.readLine();
        name = reader.readLine().substring("% File     :".length()).trim();
        status = reader.readLine().substring("% Status   :".length()).trim();
        reader.readLine();
        formula = reader.readLine();
        ProvabilityStatus stat = null;
        stat = status.equals("provable") ? ProvabilityStatus.PROVABLE : (status.equals("unprovable") ? ProvabilityStatus.UNPROVABLE : ProvabilityStatus.UNKNOWN);
        JTabWbSimpleProblem pd = new JTabWbSimpleProblem(name);
        pd.addConjecture(formula);
        pd.setProblemStatus(stat);
        return pd;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

