/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.modal.formula;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwbx.modal.basic.ModalFormulaType;
import jtabwbx.modal.basic._ModalFormulaSet;
import jtabwbx.modal.formula.ModalFormula;
import jtabwbx.modal.formula.ModalFormulaFactory;

public class BitSetOfModalFormulas
extends BitSet
implements _ModalFormulaSet,
Iterable<ModalFormula> {
    ModalFormulaFactory formulaFactory;

    public BitSetOfModalFormulas(ModalFormulaFactory factory) {
        super(factory.numberOfGeneratedFormulas());
        this.formulaFactory = factory;
    }

    @Override
    public boolean add(ModalFormula wff) {
        int idx = wff.getIndex();
        if (this.get(idx)) {
            return true;
        }
        this.set(idx);
        return false;
    }

    @Override
    public void addAll(_ModalFormulaSet set) {
        for (ModalFormula wff : set) {
            this.add(wff);
        }
    }

    public void addAll(BitSetOfModalFormulas set) {
        this.or(set);
    }

    public void and(BitSetOfModalFormulas set) {
        super.and(set);
    }

    @Override
    public BitSetOfModalFormulas clone() {
        BitSetOfModalFormulas newset = (BitSetOfModalFormulas)super.clone();
        newset.formulaFactory = this.formulaFactory;
        return newset;
    }

    @Override
    public boolean contains(ModalFormula wff) {
        return this.get(wff.getIndex());
    }

    public boolean containsFormulaOfType(ModalFormulaType type) {
        return this.getFirst(type) != null;
    }

    @Override
    public Collection<ModalFormula> getAllFormulas() {
        LinkedList<ModalFormula> list = new LinkedList<ModalFormula>();
        int i = this.nextSetBit(0);
        while (i >= 0) {
            list.add(this.formulaFactory.getByIndex(i));
            i = this.nextSetBit(i + 1);
        }
        return list.size() == 0 ? null : list;
    }

    public Collection<ModalFormula> getAllFormulas(ModalFormulaType formulaType) {
        LinkedList<ModalFormula> list = new LinkedList<ModalFormula>();
        int i = this.nextSetBit(0);
        while (i >= 0) {
            ModalFormula wff = this.formulaFactory.getByIndex(i);
            if (wff.getFormulaType() == formulaType) {
                list.add(wff);
            }
            i = this.nextSetBit(i + 1);
        }
        return list.size() == 0 ? null : list;
    }

    public BitSetOfModalFormulas getBitsetOfAllFormulas(ModalFormulaType formulaType) {
        BitSetOfModalFormulas bset = new BitSetOfModalFormulas(this.formulaFactory);
        int i = this.nextSetBit(0);
        while (i >= 0) {
            ModalFormula wff = this.formulaFactory.getByIndex(i);
            if (wff.getFormulaType() == formulaType) {
                bset.add(wff);
            }
            i = this.nextSetBit(i + 1);
        }
        return bset.isEmpty() ? null : bset;
    }

    @Override
    public ModalFormula getFirst() {
        int firstIdx = this.nextSetBit(0);
        return firstIdx == -1 ? null : this.formulaFactory.getByIndex(firstIdx);
    }

    public ModalFormula getFirstAndRemove() {
        int firstIdx = this.nextSetBit(0);
        if (firstIdx == -1) {
            return null;
        }
        ModalFormula wff = this.formulaFactory.getByIndex(firstIdx);
        this.clear(wff.getIndex());
        return wff;
    }

    public ModalFormula getFirstAndRemove(ModalFormulaType type) {
        int i = this.nextSetBit(0);
        while (i >= 0) {
            ModalFormula wff = this.formulaFactory.getByIndex(i);
            if (wff.getFormulaType() == type) {
                ModalFormula found = this.formulaFactory.getByIndex(i);
                this.clear(found.getIndex());
                return found;
            }
            i = this.nextSetBit(i + 1);
        }
        return null;
    }

    public ModalFormula getFirst(ModalFormulaType type) {
        int i = this.nextSetBit(0);
        while (i >= 0) {
            ModalFormula wff = this.formulaFactory.getByIndex(i);
            if (wff.getFormulaType() == type) {
                return this.formulaFactory.getByIndex(i);
            }
            i = this.nextSetBit(i + 1);
        }
        return null;
    }

    public ModalFormulaFactory getFactory() {
        return this.formulaFactory;
    }

    @Override
    public Iterator<ModalFormula> iterator() {
        return new Iterator<ModalFormula>(){
            int nextElement;
            {
                this.nextElement = BitSetOfModalFormulas.this.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.nextElement >= 0;
            }

            @Override
            public ModalFormula next() {
                ModalFormula wff = BitSetOfModalFormulas.this.formulaFactory.getByIndex(this.nextElement);
                this.nextElement = BitSetOfModalFormulas.this.nextSetBit(this.nextElement + 1);
                return wff;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported.");
            }
        };
    }

    @Override
    public boolean remove(ModalFormula wff) {
        boolean result = this.get(wff.getIndex());
        if (result) {
            this.flip(wff.getIndex());
        }
        return result;
    }

    @Override
    public ModalFormula[] toArray() {
        ModalFormula[] result = new ModalFormula[this.cardinality()];
        int i = this.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            result[j] = this.formulaFactory.getByIndex(i);
            i = this.nextSetBit(i + 1);
            ++j;
        }
        return result;
    }

    public boolean subseteq(BitSetOfModalFormulas other) {
        BitSetOfModalFormulas cloned = this.clone();
        cloned.and(other);
        return cloned.equals(this);
    }

    public boolean superseteq(BitSetOfModalFormulas other) {
        return other.subseteq(this);
    }

    @Override
    public String toString() {
        Collection<ModalFormula> all = this.getAllFormulas();
        if (all != null) {
            ModalFormula[] array = all.toArray(new ModalFormula[all.size()]);
            String str = "";
            int i = 0;
            while (i < array.length) {
                str = String.valueOf(str) + array[i].toString() + (i < array.length - 1 ? ", " : "");
                ++i;
            }
            return str;
        }
        return "";
    }
}

