/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.modal.btformula;

import java.util.Stack;
import jtabwb.util.ImplementationError;
import jtabwbx.modal.basic.ModalConnective;
import jtabwbx.modal.btformula.BTModalFormula;
import jtabwbx.modal.btformula.BTModalFormulaCompound;
import jtabwbx.modal.btformula.BTModalFormulaProposition;
import jtabwbx.modal.parser.ModalWffBaseListener;
import jtabwbx.modal.parser.ModalWffParser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

class BTModalFormulaBuilder
extends ModalWffBaseListener {
    private Stack<BTModalFormula> stack;

    BTModalFormulaBuilder() {
    }

    BTModalFormula buildFrom(ParseTree tree) {
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)this, tree);
        if (this.stack.size() == 1) {
            BTModalFormula wff = this.stack.pop();
            this.stack = null;
            return wff;
        }
        throw new ImplementationError();
    }

    @Override
    public void enterModalFormula(ModalWffParser.ModalFormulaContext ctx) {
        this.stack = new Stack();
    }

    @Override
    public void exitProp(ModalWffParser.PropContext ctx) {
        this.stack.push(new BTModalFormulaProposition(ctx.getText()));
    }

    @Override
    public void exitAnd(ModalWffParser.AndContext ctx) {
        BTModalFormula right = this.stack.pop();
        BTModalFormula left = this.stack.pop();
        BTModalFormulaCompound and = new BTModalFormulaCompound(ModalConnective.AND, left, right);
        this.stack.push(and);
    }

    @Override
    public void exitOr(ModalWffParser.OrContext ctx) {
        BTModalFormula right = this.stack.pop();
        BTModalFormula left = this.stack.pop();
        BTModalFormulaCompound or = new BTModalFormulaCompound(ModalConnective.OR, left, right);
        this.stack.push(or);
    }

    @Override
    public void exitImp(ModalWffParser.ImpContext ctx) {
        BTModalFormula right = this.stack.pop();
        BTModalFormula left = this.stack.pop();
        BTModalFormulaCompound imp = new BTModalFormulaCompound(ModalConnective.IMPLIES, left, right);
        this.stack.push(imp);
    }

    @Override
    public void exitEq(ModalWffParser.EqContext ctx) {
        BTModalFormula right = this.stack.pop();
        BTModalFormula left = this.stack.pop();
        BTModalFormulaCompound eq = new BTModalFormulaCompound(ModalConnective.EQ, left, right);
        this.stack.push(eq);
    }

    @Override
    public void exitNeg(ModalWffParser.NegContext ctx) {
        BTModalFormula subwff = this.stack.pop();
        BTModalFormulaCompound not = new BTModalFormulaCompound(ModalConnective.NOT, subwff);
        this.stack.push(not);
    }

    @Override
    public void exitDia(ModalWffParser.DiaContext ctx) {
        BTModalFormula subwff = this.stack.pop();
        BTModalFormulaCompound dia = new BTModalFormulaCompound(ModalConnective.DIA, subwff);
        this.stack.push(dia);
    }

    @Override
    public void exitBox(ModalWffParser.BoxContext ctx) {
        BTModalFormula subwff = this.stack.pop();
        BTModalFormulaCompound box = new BTModalFormulaCompound(ModalConnective.BOX, subwff);
        this.stack.push(box);
    }

    @Override
    public void exitPar(ModalWffParser.ParContext ctx) {
    }
}

