/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import java.util.LinkedList;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.TraceNode;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;

public class CTreeNode {
    private String INDENTATION = "  ";
    private int treatedConclusionOfParent;
    private LinkedList<CTreeNode> successors = null;
    private _AbstractRule appliedRule;
    private _AbstractGoal premise;
    private ProofSearchResult status;

    CTreeNode(TraceNode traceNode, CTreeNode parent, int treatedConclusionOfParent, ProofSearchResult status) {
        this.treatedConclusionOfParent = treatedConclusionOfParent;
        this.appliedRule = traceNode.getAppliedRule();
        this.premise = traceNode.getPremise();
        this.status = status;
    }

    public int getTreatedConclusion() {
        return this.treatedConclusionOfParent;
    }

    public void addSuccessor(CTreeNode successor) {
        if (this.successors == null) {
            this.successors = new LinkedList();
        }
        this.successors.addLast(successor);
    }

    public LinkedList<CTreeNode> getSuccessors() {
        return this.successors;
    }

    public _AbstractRule getAppliedRule() {
        return this.appliedRule;
    }

    public _AbstractGoal getNodeSet() {
        return this.premise;
    }

    public ProofSearchResult getStatus() {
        return this.status;
    }

    public String toString() {
        return this.toStringIndent("");
    }

    private String toStringIndent(String indent) {
        String str = String.valueOf(indent) + this.premise + "---" + this.appliedRule.name() + "\n";
        if (this.successors == null) {
            return str;
        }
        indent = String.valueOf(indent) + this.INDENTATION;
        for (CTreeNode succ : this.successors) {
            str = String.valueOf(str) + succ.toStringIndent(indent);
        }
        return str;
    }
}

