/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.launcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import jtabwb.engine.Engine;
import jtabwb.engine.IterationInfo;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine.TraceException;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._Prover;
import jtabwb.launcher.AvailableProvers;
import jtabwb.launcher.AvailableReaders;
import jtabwb.launcher.CmdLineOptions;
import jtabwb.launcher.ConfiguredProblemDescriptioReader;
import jtabwb.launcher.ConfiguredTheoremProver;
import jtabwb.launcher.ImplementationError;
import jtabwb.launcher.InitialGoalBuilderException;
import jtabwb.launcher.LauncherConfigurationException;
import jtabwb.launcher.LauncherExecutionException;
import jtabwb.launcher.Log;
import jtabwb.launcher.ProblemDescription;
import jtabwb.launcher.ProblemDescriptionException;
import jtabwb.launcher.ProofSearchData;
import jtabwb.launcher.ProverDefinitionException;
import jtabwb.launcher.ReaderDefinitionException;
import jtabwb.launcher._InitialGoalBuilder;
import jtabwb.launcher._ProblemReader;
import jtabwb.launcher._SingleExecutionConfigurator;
import jtabwb.tracesupport.CTree;
import jtabwb.tracesupport._LatexSupport;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Launcher {
    static final String DEFAULT_LOG_DIR_NAME = "log";
    static final String DEFAULT_LOG_FILE_NAME_PREFIX = "proofSearch-";
    static final String DEFAULT_LOG_FILE_NAME_SUFFIX = ".log";
    static final String DEFAULT_LOG_TIME_FILE_NAME_PREFIX = "time-";
    static final String DEFAULT_LOG_TIME_FILE_NAME_SUFFIX = ".log";
    static final String DEFAULT_LATEX_PROOF_FILE_NAME_PREFIX = "proof-";
    static final String DEFAULT_LATEX_PROOF_FILE_NAME_SUFFIX = ".tex";
    static final String DEFAULT_LATEX_CTREE_FILE_NAME_PREFIX = "ctrees-";
    static final String DEFAULT_LATEX_CTREE_FILE_NAME_SUFFIX = ".tex";
    static final String DEFAULT_TESTSET_FILE_PREFIX = "testset-";
    static final String DEFAULT_TESTSET_FILE_SUFFIX = ".log";
    static final String DEFAULT_TRACE_FILE_NAME_PREFIX = "trace-";
    static final String DEFAULT_TRACE_FILE_NAME_SUFFIX = ".log";
    final Log LOG = new Log();
    boolean processCmdLineOptionsExecuted = false;
    LaunchConfiguration currentConfiguration = new LaunchConfiguration();
    ProofSearchData lastProofSearchData;
    TestsetDetails testsetDetails;
    ThreadMXBean bean = ManagementFactory.getThreadMXBean();

    private _AbstractGoal buildInitialNodeSet(ProofSearchData info) {
        _AbstractGoal initialNodeSet = null;
        try {
            if (!this.currentConfiguration.testsetmode) {
                this.LOG.infoNoLn("> Building initial node set...", new Object[0]);
            }
            if (this.currentConfiguration.singleExecutionConfigurator != null) {
                this.currentConfiguration.singleExecutionConfigurator.configInitialNodeSetBuilder(info.problemDescription, this.currentConfiguration);
            }
            info.initial_node_set_construction_start_time = this.getCurrentTimeMilleseconds();
            initialNodeSet = this.currentConfiguration.initialNodeSetBuilder.buildInitialNodeSet(info.problemDescription);
            info.initial_node_set_construction_end_time = this.getCurrentTimeMilleseconds();
            if (!this.currentConfiguration.testsetmode) {
                this.LOG.info(" time (ms) [%d]", info.getIntialNodeSetConstructionTime());
            }
        }
        catch (InitialGoalBuilderException e) {
            this.LOG.error("PROBLEM BUILDING NODE SET - %s", e.getMessage());
            System.exit(1);
        }
        return initialNodeSet;
    }

    public void configLauncherName(String launcherClassName) {
        this.currentConfiguration.launcherClassName = launcherClassName;
    }

    public <T extends _Prover> void configTheoremProver(String name, Class<T> prover) throws ProverDefinitionException {
        this.configTheoremProver(name, prover, false);
    }

    public <T extends _Prover> void configTheoremProver(String name, Class<T> prover, boolean isDefault) throws ProverDefinitionException {
        _Prover instance = null;
        try {
            instance = (_Prover)prover.newInstance();
        }
        catch (InstantiationException e) {
            throw new ProverDefinitionException(String.format("Prover [%s] has not an accessible nullary constructor.", prover.getName()));
        }
        catch (IllegalAccessException e) {
            throw new ProverDefinitionException(String.format("Prover [%s] has not an accessible nullary constructor.", prover.getName()));
        }
        if (name == null || name.equals("")) {
            throw new ProverDefinitionException(String.format("The prover name cannot be null or the empty string.", new Object[0]));
        }
        if (this.currentConfiguration.availableProvers.searchByName(name) != null) {
            throw new ProverDefinitionException(String.format("A prover with name [%s] is already defined.", name));
        }
        this.currentConfiguration.availableProvers.addProver(name, instance.getProverName().getDescription(), prover, isDefault);
    }

    public <T extends _ProblemReader> void configProblemDescriptionReader(String name, Class<T> reader) throws ReaderDefinitionException {
        this.configProblemDescriptionReader(name, reader, false);
    }

    public <T extends _ProblemReader> void configProblemDescriptionReader(String name, Class<T> reader, boolean isDefault) throws ReaderDefinitionException {
        _ProblemReader instance = null;
        try {
            instance = (_ProblemReader)reader.newInstance();
        }
        catch (InstantiationException e) {
            throw new ReaderDefinitionException(String.format("Reader [%s] has not an accessible nullary constructor.", reader.getName()));
        }
        catch (IllegalAccessException e) {
            throw new ReaderDefinitionException(String.format("Reader [%s] has not an accessible nullary constructor.", reader.getName()));
        }
        if (name == null || name.equals("")) {
            throw new ReaderDefinitionException(String.format("The reader name cannot be null or the empty string.", new Object[0]));
        }
        if (this.currentConfiguration.availableReaders.searchByName(name) != null) {
            throw new ReaderDefinitionException(String.format("A reader with name [%s] is already defined.", name));
        }
        this.currentConfiguration.availableReaders.addReader(name, instance.getDescription(), reader, isDefault);
    }

    public void configInitialNodeSetBuilder(_InitialGoalBuilder builder) {
        this.currentConfiguration.initialNodeSetBuilder = builder;
    }

    public void configStandardInputReader(_ProblemReader stdInputProblemReader) {
        this.currentConfiguration.stdinReader = stdInputProblemReader;
    }

    public void optConfigSingleExecutionConfigurator(_SingleExecutionConfigurator configurator) {
        this.currentConfiguration.singleExecutionConfigurator = configurator;
    }

    private _Prover configProver(ProofSearchData info) {
        try {
            _Prover prover = (_Prover)((Class)this.currentConfiguration.selectedProver.getValue()).newInstance();
            if (this.currentConfiguration.singleExecutionConfigurator != null) {
                this.currentConfiguration.singleExecutionConfigurator.configProver(prover, info.goal, this.currentConfiguration);
            }
            this.currentConfiguration.selectedProverName = prover.getProverName();
            if ((this.currentConfiguration.generateLatexOfProof || this.currentConfiguration.generateLatexOfCtrees) && !(prover instanceof _LatexSupport)) {
                this.LOG.error("LaTeX generator: [%s] does not provide the LaTeX support.", prover.getProverName().getProperNoun());
                System.exit(0);
            }
            return prover;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public ProofSearchData getLastProofSearchData() {
        return this.lastProofSearchData;
    }

    public Options getCmdLineOptionsManager() {
        return this.currentConfiguration.cmdLineOptions;
    }

    public LaunchConfiguration getCurrentLauncherConfiguration() {
        return this.currentConfiguration;
    }

    private TestsetDetails initilizeTesetDetails() {
        TestsetDetails testsetDetails = new TestsetDetails();
        testsetDetails.proverName = this.currentConfiguration.selectedProverName;
        testsetDetails.testsetName = this.currentConfiguration.testsetName;
        testsetDetails.startTime = new Date();
        try {
            testsetDetails.tempFile = File.createTempFile("tmp-testset-" + this.replaceSpacesWithUnderscore(this.currentConfiguration.selectedProverName.getProperNoun()) + "-", ".tmp", this.getLogDir());
            testsetDetails.pw4TempFile = new PrintWriter(new BufferedWriter(new FileWriter(testsetDetails.tempFile)));
        }
        catch (IOException e) {
            this.LOG.error("Testset temporary file cannot be created: %s", e.getMessage());
            System.exit(1);
        }
        return testsetDetails;
    }

    public void launch() throws LauncherExecutionException, LauncherConfigurationException {
        try {
            if (this.currentConfiguration.launcherWelcomeMessage != null) {
                this.LOG.info(this.currentConfiguration.launcherWelcomeMessage, new Object[0]);
            }
            if (!this.processCmdLineOptionsExecuted) {
                throw new LauncherExecutionException(String.format("processCmdLineArguments() must be invoked before launch().", new Object[0]));
            }
            this.currentConfiguration.checkConfiguration();
            String[] fileNames = this.currentConfiguration.commandLine.getArgs();
            if (this.currentConfiguration.readFromStandardInput) {
                if (fileNames.length > 0) {
                    this.LOG.error("Some filename is specified but the [-i] option is set.", new Object[0]);
                    System.exit(1);
                }
            } else if (fileNames.length == 0) {
                this.LOG.error("No input specified!!", new Object[0]);
                System.exit(1);
            }
            if (this.currentConfiguration.readFromStandardInput) {
                ProofSearchData info = new ProofSearchData();
                info.problemDescription = this.readFromStandardInput(info);
                info.goal = this.buildInitialNodeSet(info);
                info.selectedProver = this.configProver(info);
                this.searchProof(info);
                this.lastProofSearchData = info;
            } else if (this.currentConfiguration.testsetmode) {
                boolean firstTest = true;
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String problemFileName = stringArray[n2];
                    ProofSearchData info = new ProofSearchData();
                    info.problemDescription = this.readFromFile(info, problemFileName);
                    info.goal = this.buildInitialNodeSet(info);
                    info.selectedProver = this.configProver(info);
                    if (firstTest) {
                        this.testsetDetails = this.initilizeTesetDetails();
                        firstTest = false;
                    }
                    this.searchProof(info);
                    this.updateTestSetDetails(info);
                    this.lastProofSearchData = info;
                    ++n2;
                }
                this.testset_printReport();
            } else {
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int problemFileName = 0;
                while (problemFileName < n) {
                    String problemFileName2 = stringArray[problemFileName];
                    ProofSearchData info = new ProofSearchData();
                    info.problemDescription = this.readFromFile(info, problemFileName2);
                    info.goal = this.buildInitialNodeSet(info);
                    info.selectedProver = this.configProver(info);
                    this.executioninfo_preDetails();
                    this.searchProof(info);
                    this.lastProofSearchData = info;
                    ++problemFileName;
                }
            }
        }
        catch (Exception e) {
            StringWriter strwr = new StringWriter();
            PrintWriter pw = new PrintWriter(strwr);
            e.printStackTrace(pw);
            this.LOG.error("The following exception occured durign launch execution:\n%s", strwr.toString());
            System.exit(1);
        }
    }

    public LaunchConfiguration processCmdLineArguments(String[] args) {
        if (this.currentConfiguration.availableReaders.isEmpty()) {
            throw new LauncherExecutionException(String.format("No reader has been defined. Readers must be added invoking the configProblemDescriptionReader() method.", new Object[0]));
        }
        if (this.currentConfiguration.availableProvers.isEmpty()) {
            throw new LauncherExecutionException(String.format("No prover has been defined. Provers must be added invoking the configTheoremProver() method.", new Object[0]));
        }
        if (this.currentConfiguration.initialNodeSetBuilder == null) {
            throw new LauncherExecutionException(String.format("No initial node set builder has been defined, set it with configureInitialNodeSetBuilder().", new Object[0]));
        }
        CmdLineOptions clo = new CmdLineOptions(this.currentConfiguration);
        this.currentConfiguration = clo.processComdLineOptions(args);
        this.processCmdLineOptionsExecuted = true;
        return this.currentConfiguration;
    }

    private ProblemDescription readFromFile(ProofSearchData info, String inputFilename) {
        try {
            File inputFile = new File(inputFilename);
            if (!inputFile.exists()) {
                this.LOG.error("No such file: %s", inputFilename);
                System.exit(1);
            }
            try {
                this.currentConfiguration.selectedReader = (_ProblemReader)((Class)this.currentConfiguration.fileReader.getValue()).newInstance();
                FileReader fir = new FileReader(inputFile);
                if (!this.currentConfiguration.testsetmode) {
                    this.LOG.infoNoLn("> Parsing problem...", new Object[0]);
                }
                if (this.currentConfiguration.singleExecutionConfigurator != null) {
                    this.currentConfiguration.singleExecutionConfigurator.configProblemReader(this.currentConfiguration.selectedReader, this.currentConfiguration);
                }
                info.parsing_problem_start_time = this.getCurrentTimeMilleseconds();
                ProblemDescription problemDescription = this.currentConfiguration.selectedReader.read(fir);
                info.parsing_problem_end_time = this.getCurrentTimeMilleseconds();
                if (!this.currentConfiguration.testsetmode) {
                    this.LOG.info(" time (ms) [%d]", info.getParsingProblemTime());
                }
                problemDescription.setSource(inputFile.getAbsolutePath());
                this.problemDetails_print(problemDescription);
                return problemDescription;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
        }
        catch (IOException e) {
            this.LOG.error("IO EXCEPTION... %s", e.getMessage());
            System.exit(1);
        }
        catch (ProblemDescriptionException e) {
            this.LOG.error("PROBLEM DESCRIPTION - wrong format: %s", e.getMessage());
            System.exit(1);
        }
        return null;
    }

    private ProblemDescription readFromStandardInput(ProofSearchData proofSearchData) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        if (this.currentConfiguration.launcherStdInputMessage != null) {
            this.LOG.info(this.currentConfiguration.launcherStdInputMessage, new Object[0]);
        }
        this.LOG.info("> Type a formula:", new Object[0]);
        try {
            String strFormula = in.readLine();
            this.currentConfiguration.selectedReader = this.currentConfiguration.stdinReader;
            this.LOG.infoNoLn("> Reading input problem with [%s]... ", this.currentConfiguration.selectedReader.getName());
            if (this.currentConfiguration.singleExecutionConfigurator != null) {
                this.currentConfiguration.singleExecutionConfigurator.configProblemReader(this.currentConfiguration.selectedReader, this.currentConfiguration);
            }
            BufferedReader reader = new BufferedReader(new StringReader(strFormula));
            proofSearchData.parsing_problem_start_time = System.currentTimeMillis();
            ProblemDescription problemDescription = this.currentConfiguration.stdinReader.read(reader);
            proofSearchData.parsing_problem_end_time = System.currentTimeMillis();
            if (problemDescription.getProblemName() == null) {
                problemDescription.setName("input");
            }
            if (problemDescription.getSource() == null) {
                problemDescription.setSource("std-input");
            }
            if (problemDescription.getProblemStatus() == null) {
                problemDescription.setProblemStatus(ProvabilityStatus.UNKNOWN);
            }
            this.LOG.info(" time (ms) [%d]", proofSearchData.getParsingProblemTime());
            this.problemDetails_print(problemDescription);
            return problemDescription;
        }
        catch (ProblemDescriptionException e) {
            this.LOG.error("PARSER ERROR... %s", e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            this.LOG.error("IO EXCEPTION... %s", e.getMessage());
            System.exit(1);
        }
        return null;
    }

    private void searchProof(ProofSearchData proofSearchData) {
        Engine engine = new Engine(proofSearchData.selectedProver, proofSearchData.goal, this.currentConfiguration.engineExecutionMode);
        if (!this.currentConfiguration.testsetmode) {
            this.LOG.info("> Proving...", new Object[0]);
        }
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        proofSearchData.execution_start_time = this.getCurrentTimeMilleseconds();
        long cpuTime = bean.getCurrentThreadCpuTime();
        engine.searchProof();
        cpuTime = bean.getCurrentThreadCpuTime() - cpuTime;
        proofSearchData.execution_end_time = this.getCurrentTimeMilleseconds();
        IterationInfo lastIterationInfo = engine.getLastIterationInfo();
        proofSearchData.proofSearchResult = engine.getResult();
        proofSearchData.testStatus = TestStatus.getTestStatus(proofSearchData);
        proofSearchData.iterationCounter = lastIterationInfo.getNumberOfIterations();
        proofSearchData.max_stack_size = lastIterationInfo.getMaxStackSize();
        proofSearchData.proofSearchResult = engine.getResult();
        proofSearchData.numberOfRestoredBacktrackPoints = lastIterationInfo.getNumberOfRestoredBacktrackPoints();
        proofSearchData.numberOfGeneratedNodes = lastIterationInfo.getNumberOfGeneratedNodes();
        proofSearchData.numberOfRestoredBranchPoints = lastIterationInfo.getNumberOfRestoredBranchPoints();
        if (this.currentConfiguration.engineExecutionMode == Engine.ExecutionMode.ENGINE_TRACE) {
            proofSearchData.trace = engine.getTrace();
        }
        if (this.currentConfiguration.testsetmode) {
            this.testset_printSingleTestInfo(proofSearchData);
        } else {
            this.executionInfo_print(proofSearchData);
            if (this.currentConfiguration.generateLogFile) {
                this.log_generateFile(proofSearchData);
            }
            if (this.currentConfiguration.generateLogTimeFile) {
                this.timeLog_generateFile(proofSearchData);
            }
            if (this.currentConfiguration.generateLatexOfProof) {
                this.latexProof_generateFile(proofSearchData);
            }
            if (this.currentConfiguration.generateLatexOfCtrees) {
                this.latexCtrees_generateFile(proofSearchData);
            }
            if (this.currentConfiguration.saveTrace) {
                this.trace_generateFile(proofSearchData);
            }
            if (this.currentConfiguration.generatef3TimeStr) {
                this.timing_f3time_generateString(proofSearchData);
            }
            if (this.currentConfiguration.generateJTabWbTimeStr) {
                this.timing_jtabwb_generatesString(proofSearchData);
            }
        }
    }

    private void updateTestSetDetails(ProofSearchData proofSearchData) {
        ++this.testsetDetails.numberOfTests;
        this.testsetDetails.totalProofSearchTime += proofSearchData.getExecutionTime();
        this.testsetDetails.totalProblemParsingTime += proofSearchData.getParsingProblemTime();
        this.testsetDetails.totalInitalNodeSetConstructionTime += proofSearchData.getIntialNodeSetConstructionTime();
        switch (proofSearchData.proofSearchResult) {
            case FAILURE: {
                ++this.testsetDetails.unsuccesfulProofSearch;
                break;
            }
            case SUCCESS: {
                ++this.testsetDetails.succesfullProofSearch;
                break;
            }
            default: {
                throw new ImplementationError("Case not implemented!");
            }
        }
        TestStatus testStatus = TestStatus.getTestStatus(proofSearchData);
        switch (testStatus) {
            case UNCHECKED: {
                ++this.testsetDetails.uncheckedTests;
                break;
            }
            case PASSED: {
                ++this.testsetDetails.successfulTests;
                break;
            }
            case FAILED: {
                ++this.testsetDetails.failedTests;
                break;
            }
            default: {
                throw new ImplementationError("Case not implemented!");
            }
        }
        switch (proofSearchData.problemDescription.getProblemStatus()) {
            case PROVABLE: {
                ++this.testsetDetails.provableProblems;
                break;
            }
            case UNKNOWN: {
                ++this.testsetDetails.unknownProblems;
                break;
            }
            case UNPROVABLE: {
                ++this.testsetDetails.unprovableProblems;
                break;
            }
            default: {
                throw new ImplementationError("Case not implemented!");
            }
        }
    }

    public void optConfigCmdLineOptions(Options options) throws LauncherConfigurationException {
        for (Option opt : options.getOptions()) {
            this.currentConfiguration.cmdLineOptions.addOption(opt);
        }
    }

    public void setTraceGenerationMode(boolean flag) {
        if (flag) {
            this.currentConfiguration.engineExecutionMode = Engine.ExecutionMode.ENGINE_TRACE;
        }
        this.currentConfiguration.checkConfiguration();
    }

    public void optConfigWelcomeMessage(String str) {
        this.currentConfiguration.launcherWelcomeMessage = str;
    }

    public void optConfigInputSyntax(String str) {
        this.currentConfiguration.launcherStdInputMessage = str;
    }

    private void executioninfo_preDetails() {
        this.LOG.info("** Prover [%s]", this.currentConfiguration.selectedProverName.getDetailedName());
        if (this.currentConfiguration.readFromStandardInput) {
            this.LOG.infoNoLn("** Std-input reader [%s]", this.currentConfiguration.stdinReader.getDescription());
        } else {
            this.LOG.info("** Reader [%s]", this.currentConfiguration.selectedReader.getName());
        }
    }

    private String executionInfo_buildString(ProofSearchData proofSearchData) {
        StringBuffer sb = new StringBuffer();
        sb.append("****************************************************************");
        sb.append("\n");
        sb.append(String.format("** Prover [%s]", proofSearchData.selectedProver.getProverName().getDetailedName()));
        sb.append("\n");
        sb.append(String.format("** Problem [%s], status [%s], proof-search [%s], test [%s]", new Object[]{proofSearchData.problemDescription.getProblemName(), proofSearchData.problemDescription.getProblemStatus().name(), proofSearchData.proofSearchResult, TestStatus.getTestStatus(proofSearchData).name()}));
        sb.append("\n");
        sb.append(String.format("** Generated nodes [%d], restored backtrack-points [%d], restored branch-points [%d]", proofSearchData.numberOfGeneratedNodes, proofSearchData.numberOfRestoredBacktrackPoints, proofSearchData.numberOfRestoredBranchPoints));
        sb.append("\n");
        long proofSearch_time = proofSearchData.getExecutionTime();
        long buildInitialNodeSet_time = proofSearchData.getIntialNodeSetConstructionTime();
        long problemReading_time = proofSearchData.getParsingProblemTime();
        long totalProof_time = buildInitialNodeSet_time + proofSearch_time + problemReading_time;
        sb.append(String.format("** Timings (ms): PS (proof-search) [%d], NSC (initial node set) [%d], PP (problem parsing) [%d]", proofSearch_time, buildInitialNodeSet_time, problemReading_time));
        sb.append("\n");
        String convertedTime = this.buildTimeString(totalProof_time);
        if (convertedTime == null) {
            sb.append(String.format("** Proof time (PS + NSC + PP): (ms) [%d]", totalProof_time));
        } else {
            sb.append(String.format("** Proof time (PS + NSC + PP): (ms) [%d] (hh:mm:ss + ms) [%s]", totalProof_time, convertedTime.toString()));
        }
        sb.append("\n");
        sb.append("****************************************************************");
        return sb.toString();
    }

    private void executionInfo_print(ProofSearchData proofSearchData) {
        this.LOG.info(this.executionInfo_buildString(proofSearchData), new Object[0]);
    }

    private void problemDetails_print(ProblemDescription problemDescription) {
        if (this.currentConfiguration.testsetmode) {
            this.LOG.infoNoLn(String.format("** [%s], status [%s],", problemDescription.getProblemName(), problemDescription.getProblemStatus().toString()), new Object[0]);
        } else {
            this.LOG.info(String.format("** Problem [%s], status [%s]", problemDescription.getProblemName(), problemDescription.getProblemStatus().toString()), new Object[0]);
        }
    }

    private String testset_buildLogFileSingleTestDescription(ProofSearchData proofSearchData) {
        long proofSearch_time = proofSearchData.getExecutionTime();
        long buildInitialNodeSet_time = proofSearchData.getIntialNodeSetConstructionTime();
        long problemReading_time = proofSearchData.getParsingProblemTime();
        long totalProof_time = buildInitialNodeSet_time + proofSearch_time;
        return String.format("test: %s, %s, %s, %s; times (ms): %d, %d, %d, %d; details: %d; %d; %d; %d; %d; %s", proofSearchData.problemDescription.getProblemName(), proofSearchData.problemDescription.getProblemStatus().name(), proofSearchData.proofSearchResult.name(), proofSearchData.testStatus.name(), totalProof_time, proofSearch_time, buildInitialNodeSet_time, problemReading_time, proofSearchData.iterationCounter, proofSearchData.numberOfGeneratedNodes, proofSearchData.max_stack_size, proofSearchData.numberOfRestoredBranchPoints, proofSearchData.numberOfRestoredBacktrackPoints, proofSearchData.problemDescription.getSource());
    }

    private void timing_f3time_generateString(ProofSearchData proofSearchData) {
        String result = null;
        switch (proofSearchData.selectedProver.statusFor(proofSearchData.proofSearchResult)) {
            case PROVABLE: {
                result = "provable";
                break;
            }
            case UNPROVABLE: {
                result = "uprovable";
                break;
            }
            case UNKNOWN: {
                result = "unknown";
                break;
            }
            default: {
                throw new ImplementationError("Case not implemented!");
            }
        }
        String str = String.valueOf(this.buildF3TimeString(proofSearchData.getParsingProblemTime() + proofSearchData.getExecutionTime() + proofSearchData.getIntialNodeSetConstructionTime())) + "\n" + result;
        this.LOG.info(str, new Object[0]);
    }

    private void timing_jtabwb_generatesString(ProofSearchData proofSearchData) {
        long proofSearch_time = proofSearchData.getExecutionTime();
        long buildInitialNodeSet_time = proofSearchData.getIntialNodeSetConstructionTime();
        long problemReading_time = proofSearchData.getParsingProblemTime();
        long totalProof_time = buildInitialNodeSet_time + proofSearch_time;
        this.LOG.info(String.format("%s; %s; %s; %s; %s; %s; %s; %s; %d; %d; %d", proofSearchData.problemDescription.getProblemName(), proofSearchData.problemDescription.getProblemStatus().name(), proofSearchData.proofSearchResult.name(), proofSearchData.testStatus.name(), this.buildSecondBasedString(totalProof_time), this.buildSecondBasedString(proofSearch_time), this.buildSecondBasedString(buildInitialNodeSet_time), this.buildSecondBasedString(problemReading_time), proofSearchData.numberOfGeneratedNodes, proofSearchData.numberOfRestoredBacktrackPoints, proofSearchData.numberOfRestoredBranchPoints), new Object[0]);
    }

    private String buildSecondBasedString(long miliSeconds) {
        int sec = (int)TimeUnit.MILLISECONDS.toSeconds(miliSeconds);
        int mil = (int)miliSeconds % 1000;
        return String.format("%d.%03d", sec, mil);
    }

    private String buildF3TimeString(long miliSeconds) {
        int sec = (int)TimeUnit.MILLISECONDS.toSeconds(miliSeconds);
        int mil = (int)miliSeconds % 1000;
        return String.format("%d.%03d seconds", sec, mil);
    }

    private long getCurrentTimeMilleseconds() {
        return TimeUnit.MILLISECONDS.convert(this.bean.getCurrentThreadCpuTime(), TimeUnit.NANOSECONDS);
    }

    private void latexCtrees_generateFile(ProofSearchData proofSearchData) {
        Collection<CTree> ctrees = CTree.buildFrom(proofSearchData.trace);
        if (ctrees == null) {
            this.LOG.error("CTREES (LaTeX) GENERATION: no c-tree defined by the proof-search!", new Object[0]);
            return;
        }
        try {
            File file = new File(this.fileNameFrom(proofSearchData.problemDescription.getProblemName(), this.currentConfiguration.latexCtreesFileNamePrefix, this.currentConfiguration.latexCtreesFileNameSuffix));
            PrintStream ps = new PrintStream(file);
            this.LOG.infoNoLn("> Generating latex... ", new Object[0]);
            CTree.toLatex(ctrees, ps, ((_LatexSupport)((Object)proofSearchData.selectedProver)).getLatexProofFormatter());
            this.LOG.info("saved in [%s]", file.getAbsolutePath());
        }
        catch (IOException e) {
            this.LOG.error(String.format("IO EXCEPTION... %s", e.getMessage()), new Object[0]);
            System.exit(1);
        }
        catch (TraceException e) {
            this.LOG.error(String.format("LATEX GENERATION: %s.", e.getMessage()), new Object[0]);
            System.exit(1);
        }
    }

    private void latexProof_generateFile(ProofSearchData proofSearchData) {
        if (proofSearchData.trace.getStatus() != ProofSearchResult.SUCCESS) {
            this.LOG.error("PROOF (LaTeX) GENERATION: translation can be performed only for a successful proof-search.", new Object[0]);
            return;
        }
        try {
            File file = new File(this.fileNameFrom(proofSearchData.problemDescription.getProblemName(), this.currentConfiguration.latexProofFileNamePrefix, this.currentConfiguration.latexProofFileNameSuffix));
            PrintStream ps = new PrintStream(file);
            proofSearchData.trace.pruneSuccessful();
            Collection<CTree> ctrees = CTree.buildFrom(proofSearchData.trace);
            this.LOG.infoNoLn("> Generating latex... ", new Object[0]);
            CTree.toLatex(ctrees, ps, ((_LatexSupport)((Object)proofSearchData.selectedProver)).getLatexProofFormatter());
            this.LOG.info("saved in [%s]", file.getAbsolutePath());
        }
        catch (IOException e) {
            this.LOG.error(String.format("IO EXCEPTION... %s", e.getMessage()), new Object[0]);
            System.exit(1);
        }
        catch (TraceException e) {
            this.LOG.error(String.format("LATEX GENERATION: %s.", e.getMessage()), new Object[0]);
            System.exit(1);
        }
    }

    private String testset_buildConciseTimingDescription(ProofSearchData proofSearchData) {
        long proofSearch_time = proofSearchData.getExecutionTime();
        long buildInitialNodeSet_time = proofSearchData.getIntialNodeSetConstructionTime();
        long problemReading_time = proofSearchData.getParsingProblemTime();
        long totalProof_time = buildInitialNodeSet_time + proofSearch_time;
        return String.format(" proof-search [%s], test [%s] %s\n   Iterations [%d], max_stack [%d], nodes [%d], branches [%d], backtracks [%d]\n   Times (sec.): total [%s], proof-search [%s], initial node set construction [%s], problem parsing [%s]", proofSearchData.proofSearchResult.name(), proofSearchData.testStatus.name(), proofSearchData.testStatus == TestStatus.FAILED ? "<<==================" : "", proofSearchData.iterationCounter, proofSearchData.max_stack_size, proofSearchData.numberOfGeneratedNodes, proofSearchData.numberOfRestoredBranchPoints, proofSearchData.numberOfRestoredBacktrackPoints, this.buildSecondBasedString(totalProof_time + problemReading_time), this.buildSecondBasedString(proofSearch_time), this.buildSecondBasedString(buildInitialNodeSet_time), this.buildSecondBasedString(problemReading_time));
    }

    private void testset_printSingleTestInfo(ProofSearchData proofSearchData) {
        this.LOG.info(this.testset_buildConciseTimingDescription(proofSearchData), new Object[0]);
        String s = this.testset_buildLogFileSingleTestDescription(proofSearchData);
        this.testsetDetails.pw4TempFile.println(s);
    }

    private void testset_printReport() {
        this.testsetDetails.pw4TempFile.flush();
        this.testsetDetails.pw4TempFile.close();
        String logFileName = String.valueOf(this.currentConfiguration.testsetFilePrefix) + this.currentConfiguration.selectedProverName.getProperNoun() + "-" + this.currentConfiguration.testsetName + "-" + new SimpleDateFormat("yyMMdd_HHmmss").format(this.testsetDetails.startTime) + this.currentConfiguration.testsetFileSuffix;
        this.testsetDetails.logFile = new File(this.getLogDir(), logFileName);
        try {
            this.testsetDetails.pw4TestsetFile = new PrintWriter(new BufferedWriter(new FileWriter(this.testsetDetails.logFile)));
        }
        catch (IOException e) {
            this.LOG.error("Testset log file [%s] cannot be created: %s", this.testsetDetails.logFile.getAbsolutePath(), e.getMessage());
            System.exit(1);
        }
        StringBuffer filePreamble = new StringBuffer();
        filePreamble.append(String.format("** Prover: %s; version=%s; variant=(%s)", this.testsetDetails.proverName.getProperNoun(), this.testsetDetails.proverName.getVersion(), this.testsetDetails.proverName.getVariant()));
        filePreamble.append("\n");
        filePreamble.append(String.format("** Testset: %s", this.testsetDetails.testsetName));
        StringBuffer detailsStr = new StringBuffer();
        detailsStr.append(String.format("** Problems: total [%d], provable [%d], unprovable [%d], unknown status [%d]", this.testsetDetails.numberOfTests, this.testsetDetails.provableProblems, this.testsetDetails.unprovableProblems, this.testsetDetails.unknownProblems));
        detailsStr.append("\n");
        detailsStr.append(String.format("** Test report: failed [%d], successful [%d], unchecked [%d]", this.testsetDetails.failedTests, this.testsetDetails.successfulTests, this.testsetDetails.uncheckedTests));
        detailsStr.append("\n");
        detailsStr.append(String.format("** Total timings (sec): PS (proof-search) [%s], NSC (initial node set) [%s], PP (problem parsing) [%s]", this.buildSecondBasedString(this.testsetDetails.totalProofSearchTime), this.buildSecondBasedString(this.testsetDetails.totalInitalNodeSetConstructionTime), this.buildSecondBasedString(this.testsetDetails.totalProblemParsingTime)));
        detailsStr.append("\n");
        long totalProofTime = this.testsetDetails.totalInitalNodeSetConstructionTime + this.testsetDetails.totalProofSearchTime;
        String convertedProofTime = this.buildTimeString(totalProofTime);
        String strTime = "";
        strTime = convertedProofTime == null ? String.format("** Total proof time (PS + NSC) (sec): [%s]", this.buildSecondBasedString(totalProofTime)) : String.format("** Total proof time (PS + NSC) (sec): [%s] (hh:mm:ss + ms) [%s]", this.buildF3TimeString(totalProofTime), convertedProofTime);
        detailsStr.append(strTime);
        detailsStr.append("\n");
        long totaltime = this.testsetDetails.totalInitalNodeSetConstructionTime + this.testsetDetails.totalProofSearchTime + this.testsetDetails.totalProblemParsingTime;
        String convertedTotalTime = this.buildTimeString(totaltime);
        strTime = "";
        strTime = convertedTotalTime == null ? String.format("** Total proof time (PS + NSC + PP) (sec): [%s]", this.buildSecondBasedString(totaltime)) : String.format("** Total proof time (PS + NSC + PP) (sec): [%s] (hh:mm:ss + ms) [%s]", this.buildF3TimeString(totaltime), convertedTotalTime);
        detailsStr.append(strTime);
        this.testsetDetails.pw4TestsetFile.println(filePreamble.toString());
        this.testsetDetails.pw4TestsetFile.println(detailsStr.toString());
        StringBuffer toTest = new StringBuffer();
        toTest.append("****************************************************************");
        toTest.append("\n");
        toTest.append("** Single problems report, columns description:\n**   test: problem, status, proof-search result, test result;\n**   times (ms): proof-time (PS + NSC), PS (proof-search), NSC (initial node set construction), PP (problem parsing);\n**   details: iterations, generated nodes, max stack size, visited branches, failed branches;\n**   problem source file");
        toTest.append("\n");
        toTest.append("** --------------------------------------------------------------");
        this.testsetDetails.pw4TestsetFile.println(toTest.toString());
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.testsetDetails.tempFile));
            while ((line = br.readLine()) != null) {
                this.testsetDetails.pw4TestsetFile.println(line);
            }
            br.close();
            this.testsetDetails.tempFile.delete();
        }
        catch (IOException e) {
            this.LOG.error(String.format("Testset temporary file cannot be opened: %s", e.getMessage()), new Object[0]);
            System.exit(1);
        }
        this.testsetDetails.pw4TestsetFile.flush();
        this.testsetDetails.pw4TestsetFile.close();
        StringBuffer outPreamble = new StringBuffer();
        outPreamble.append("****************************************************************");
        outPreamble.append("\n");
        outPreamble.append(String.format("** Prover [%s]", this.testsetDetails.proverName.getDetailedName()));
        this.LOG.info(outPreamble.toString(), new Object[0]);
        this.LOG.info(detailsStr.toString(), new Object[0]);
        this.LOG.info("****************************************************************", new Object[0]);
    }

    private String replaceSpacesWithUnderscore(String name) {
        return name.trim().replaceAll("\\s", "_");
    }

    private String fileNameFrom(String name, String prefix, String suffux) {
        return String.valueOf(prefix) + this.replaceSpacesWithUnderscore(name) + suffux;
    }

    private String buildTimeString(long miliSeconds) {
        int hrs = (int)TimeUnit.MILLISECONDS.toHours(miliSeconds);
        int min = (int)TimeUnit.MILLISECONDS.toMinutes(miliSeconds) % 60;
        int sec = (int)TimeUnit.MILLISECONDS.toSeconds(miliSeconds) % 60;
        int mil = (int)miliSeconds % 1000;
        if (hrs == 0 && min == 0 && sec == 0) {
            return null;
        }
        return String.format("%02d:%02d:%02d + %d", hrs, min, sec, mil);
    }

    private File getLogDir() {
        File logDir = new File(this.currentConfiguration.logDirAbsolutePath);
        if (!logDir.exists()) {
            try {
                logDir.mkdir();
                return logDir;
            }
            catch (SecurityException e) {
                this.LOG.error("Log directory [%s] cannot be created: %s", logDir.getAbsolutePath(), e.getMessage());
                return null;
            }
        }
        if (!logDir.isDirectory()) {
            this.LOG.error("Log selected directory [%s] is not a directory.", logDir.getAbsolutePath());
            return null;
        }
        return logDir;
    }

    private void log_generateFile(ProofSearchData proofSearchData) {
        String executionInfo = this.executionInfo_buildString(proofSearchData);
        File logDir = this.getLogDir();
        if (logDir == null) {
            this.LOG.error("Log file cannot be generated.", new Object[0]);
            return;
        }
        File file = new File(logDir, this.fileNameFrom(proofSearchData.problemDescription.getProblemName(), this.currentConfiguration.logFileNamePrefix, this.currentConfiguration.logFileNameSuffix));
        this.LOG.writeToFile(file, executionInfo);
        this.LOG.info("> Log saved in [%s]", file.getAbsolutePath());
    }

    private void timeLog_generateFile(ProofSearchData proofSearchData) {
        File file = new File(this.fileNameFrom(proofSearchData.problemDescription.getProblemName(), this.currentConfiguration.logTimeFileNamePrefix, this.currentConfiguration.logTimeFileNameSuffix));
        this.LOG.writeToFile(file, this.testset_buildLogFileSingleTestDescription(proofSearchData));
        this.LOG.info("> Time log saved in [%s]", file.getAbsolutePath());
    }

    private void trace_generateFile(ProofSearchData info) {
        this.LOG.infoNoLn("> Generating trace...", new Object[0]);
        try {
            File file = new File(this.fileNameFrom(info.problemDescription.getProblemName(), this.currentConfiguration.traceFileNamePrefix, this.currentConfiguration.traceFileNameSuffix));
            PrintStream out = new PrintStream(file);
            info.trace.print(out);
            if (file != null) {
                this.LOG.info("saved in [%s]", file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.LOG.error(String.format("IO EXCEPTION... %s", e.getMessage()), new Object[0]);
            System.exit(1);
        }
    }

    public static class LaunchConfiguration {
        AvailableProvers availableProvers = new AvailableProvers();
        AvailableReaders availableReaders = new AvailableReaders();
        boolean generatef3TimeStr = false;
        boolean generateJTabWbTimeStr = false;
        boolean generateLatexOfProof = false;
        boolean generateLatexOfCtrees = false;
        boolean generateLogFile = false;
        boolean generateLogTimeFile = false;
        boolean readFromStandardInput = false;
        boolean saveTrace = false;
        boolean verboseExecutionMode = false;
        boolean testsetmode = false;
        CommandLine commandLine;
        _ProblemReader stdinReader = null;
        ConfiguredProblemDescriptioReader fileReader;
        _InitialGoalBuilder initialNodeSetBuilder = null;
        _ProblemReader selectedReader = null;
        _SingleExecutionConfigurator singleExecutionConfigurator;
        ConfiguredTheoremProver selectedProver = null;
        ProverName selectedProverName = null;
        Engine.ExecutionMode engineExecutionMode = Engine.ExecutionMode.ENGINE_PLAIN;
        String logDirAbsolutePath = "log";
        String latexCtreesFileNamePrefix = "ctrees-";
        String latexCtreesFileNameSuffix = ".tex";
        String latexProofFileNamePrefix = "proof-";
        String latexProofFileNameSuffix = ".tex";
        String launcherWelcomeMessage = null;
        String launcherStdInputMessage = null;
        String launcherClassName = null;
        String logFileNamePrefix = "proofSearch-";
        String logFileNameSuffix = ".log";
        String logTimeFileNamePrefix = "time-";
        String logTimeFileNameSuffix = ".log";
        String testsetName = null;
        String testsetFilePrefix = "testset-";
        String testsetFileSuffix = ".log";
        String traceFileNamePrefix = "trace-";
        String traceFileNameSuffix = ".log";
        Options cmdLineOptions = new Options();

        public boolean isTraceExecutionMode() {
            return this.engineExecutionMode == Engine.ExecutionMode.ENGINE_TRACE;
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }

        public _ProblemReader getSelectedReader() {
            return this.selectedReader;
        }

        public ConfiguredTheoremProver getSelectedProver() {
            return this.selectedProver;
        }

        public void checkConfiguration() {
            if (this.verboseExecutionMode && this.engineExecutionMode == Engine.ExecutionMode.ENGINE_TRACE) {
                throw new LauncherConfigurationException(String.format("Incompatible flags [%s] and [%s].", "verboseExecution", "generateTrace"));
            }
        }
    }

    public static enum TestStatus {
        UNCHECKED,
        PASSED,
        FAILED;


        static TestStatus getTestStatus(ProofSearchData info) {
            ProvabilityStatus problemStatus = info.problemDescription.getProblemStatus();
            if (problemStatus == ProvabilityStatus.UNKNOWN) {
                return UNCHECKED;
            }
            if (problemStatus == info.selectedProver.statusFor(info.proofSearchResult)) {
                return PASSED;
            }
            if (problemStatus != info.selectedProver.statusFor(info.proofSearchResult)) {
                return FAILED;
            }
            throw new ImplementationError("Case not implemented!");
        }
    }

    static class TestsetDetails {
        ProverName proverName;
        File tempFile = null;
        File logFile = null;
        PrintWriter pw4TempFile = null;
        PrintWriter pw4TestsetFile = null;
        String testsetName = null;
        Date startTime = null;
        int numberOfTests = 0;
        int provableProblems = 0;
        int unprovableProblems = 0;
        int unknownProblems = 0;
        int succesfullProofSearch = 0;
        int unsuccesfulProofSearch = 0;
        int successfulTests = 0;
        int failedTests = 0;
        int uncheckedTests = 0;
        long totalProofSearchTime = 0L;
        long totalProblemParsingTime = 0L;
        long totalInitalNodeSetConstructionTime = 0L;

        TestsetDetails() {
        }
    }
}

