/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import java.util.LinkedList;
import jtabwb.engine.ImplementationError;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.RuleType;
import jtabwb.engine.TraceStack;
import jtabwb.engine._AbstractFormula;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._RegularRule;

public class TraceNode {
    private int nodeIndex;
    private _AbstractGoal premise;
    _AbstractRule appliedRule;
    private RuleType ruleType;
    ProofSearchResult status;
    LinkedList<TraceNode> children;
    TraceNode parent;
    private TraceNode nodeDeterminingPremise;
    private int nodeDeterminingPremiseTreatedConclusion;
    private int maxNumberOfSuccessors;

    TraceNode(_AbstractGoal premise, TraceStack.GeneratingPremise generatingPremise, _AbstractRule appliedRule, TraceNode parent, int nodeNumber) {
        this.premise = premise;
        this.nodeDeterminingPremise = generatingPremise == null ? null : generatingPremise.node;
        this.nodeDeterminingPremiseTreatedConclusion = generatingPremise == null ? -1 : generatingPremise.idxConclusion;
        this.appliedRule = appliedRule;
        this.ruleType = RuleType.getType(appliedRule);
        this.status = null;
        this.parent = parent;
        this.nodeIndex = nodeNumber;
        switch (this.ruleType) {
            case CLASH_DETECTION_RULE: 
            case FORCE_BRANCH_FAILURE: 
            case FORCE_BRANCH_SUCCESS: {
                this.maxNumberOfSuccessors = 0;
                break;
            }
            case REGULAR: {
                this.maxNumberOfSuccessors = ((_RegularRule)appliedRule).numberOfSubgoals();
                break;
            }
            case BRANCH_EXISTS: {
                this.maxNumberOfSuccessors = ((_BranchExistsRule)appliedRule).numberOfBranchExistsSubgoals();
                break;
            }
            case META_BACKTRACK_RULE: {
                this.maxNumberOfSuccessors = ((_MetaBacktrackRule)appliedRule).totalNumberOfRules();
                break;
            }
            default: {
                throw new ImplementationError();
            }
        }
    }

    public _AbstractGoal getPremise() {
        return this.premise;
    }

    public int getNodeDeterminingPremiseTreatedConclusion() {
        return this.nodeDeterminingPremiseTreatedConclusion;
    }

    public TraceNode getNodeDeterminingPremise() {
        return this.nodeDeterminingPremise;
    }

    public _AbstractRule getAppliedRule() {
        return this.appliedRule;
    }

    public int getMaxNumberOfSuccessors() {
        return this.maxNumberOfSuccessors;
    }

    public TraceNode getParent() {
        return this.parent;
    }

    void addChild(TraceNode node) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(node);
    }

    void replaceChild(TraceNode oldNode, TraceNode newNode) {
        int i = 0;
        while (i < this.children.size()) {
            if (this.children.get(i).equals(oldNode)) {
                this.children.remove(i);
                this.children.add(i, newNode);
            }
            ++i;
        }
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    public ProofSearchResult getStatus() {
        return this.status;
    }

    void setStatus(ProofSearchResult status) {
        if (this.status != null) {
            return;
        }
        this.status = status;
        if (this.children != null) {
            for (TraceNode tn : this.children) {
                tn.setStatus(status);
            }
        }
    }

    public LinkedList<TraceNode> getChildren() {
        return this.children;
    }

    void print() {
        System.out.println(this.toString());
        if (this.children != null) {
            for (TraceNode n : this.children) {
                n.print();
            }
        }
    }

    public String toString() {
        String treatedConclusion;
        _AbstractFormula wff;
        String successors = "";
        if (this.children == null) {
            successors = "";
        } else {
            for (TraceNode tn : this.children) {
                successors = String.valueOf(successors) + " #" + tn.nodeIndex;
            }
        }
        switch (this.ruleType) {
            case BRANCH_EXISTS: {
                wff = ((_BranchExistsRule)this.appliedRule).mainFormula();
                break;
            }
            case REGULAR: {
                wff = ((_RegularRule)this.appliedRule).mainFormula();
                break;
            }
            default: {
                wff = null;
            }
        }
        String strNumber = "#" + this.nodeIndex;
        String strWff = "";
        if (wff != null) {
            String space = String.format("%-" + (strNumber.length() + 3) + "s", " ");
            strWff = String.format("\n%sMAIN FORMULA: %s", space, wff.format());
        }
        if ((treatedConclusion = this.toStringTreatedConclusion(this)) != null) {
            String space = String.format("%-" + (strNumber.length() + 3) + "s", " ");
            treatedConclusion = String.format("\n%s%s", space, treatedConclusion);
        } else {
            treatedConclusion = "";
        }
        return String.valueOf(strNumber) + " - STATUS: " + (this.status == null ? "NULL" : this.status.name()) + ", " + this.ruleType.name() + "[" + this.appliedRule.name() + "], SUCCESSORS[" + this.maxNumberOfSuccessors + "]:" + successors + strWff + treatedConclusion;
    }

    private String toStringTreatedConclusion(TraceNode tn) {
        if (tn.nodeDeterminingPremise == null) {
            return null;
        }
        String counter = "[" + (this.nodeDeterminingPremiseTreatedConclusion + 1) + "/" + tn.nodeDeterminingPremise.maxNumberOfSuccessors + "] of " + "#" + this.nodeDeterminingPremise.nodeIndex;
        switch (tn.nodeDeterminingPremise.ruleType) {
            case CLASH_DETECTION_RULE: {
                return this.toStringTreatedConclusion(tn.parent);
            }
            case REGULAR: {
                return "Treats conclusion " + counter;
            }
            case BRANCH_EXISTS: {
                return "Treats branch-exists conclusion " + counter;
            }
            case META_BACKTRACK_RULE: {
                return "Treats backtrack rule " + counter;
            }
        }
        throw new ImplementationError();
    }

    public int hashCode() {
        return this.nodeIndex;
    }
}

