/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.ImplementationError;
import jtabwb.engine.MSG;

public class ProverName
implements Comparable<ProverName> {
    private String properNoun = null;
    private String version = null;
    private String variant = null;
    private String description = null;

    public ProverName(String properNoun) {
        this(properNoun, null, null, null);
    }

    public ProverName(String properNoun, String version) {
        this(properNoun, version, null, null);
    }

    public ProverName(String properNoun, String version, String variant) {
        this(properNoun, version, variant, null);
    }

    public ProverName(String properNoun, String version, String variant, String description) {
        if (properNoun == null) {
            throw new ImplementationError("properNoun cannot be empty.");
        }
        this.properNoun = properNoun;
        this.version = version;
        this.variant = variant;
        this.description = description;
    }

    public String getProperNoun() {
        return this.properNoun;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVariant() {
        return this.variant;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDetailedName() {
        return String.valueOf(this.properNoun) + (this.version == null ? "" : " " + this.version) + (this.variant != null ? " (" + this.variant + ")" : "");
    }

    public void setProperNoun(String properNoun) {
        if (properNoun == null) {
            throw new ImplementationError(MSG.getMsg("Argument [%s] cannot be null!", "properNoun"));
        }
        this.properNoun = properNoun;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int compareTo(ProverName o) {
        int cversion;
        int cname = this.properNoun.compareTo(o.properNoun);
        if (cname != 0) {
            return cname;
        }
        int n = this.version == null ? (o.version == null ? 0 : -1) : (cversion = o.version == null ? 1 : this.version.compareTo(o.version));
        if (cversion != 0) {
            return cversion;
        }
        int cvariant = this.variant == null ? (o.variant == null ? 0 : -1) : (o.variant == null ? 1 : this.variant.compareTo(o.variant));
        return cvariant;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properNoun == null ? 0 : this.properNoun.hashCode());
        result = 31 * result + (this.variant == null ? 0 : this.variant.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProverName other = (ProverName)obj;
        if (this.properNoun == null ? other.properNoun != null : !this.properNoun.equals(other.properNoun)) {
            return false;
        }
        if (this.variant == null ? other.variant != null : !this.variant.equals(other.variant)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "ProverName [properNoun=" + this.properNoun + ", version=" + this.version + ", variant=" + this.variant + ", description=" + this.description + "]";
    }
}

