/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.EnginePlain;
import jtabwb.engine.VerboseModeSupport;
import jtabwb.engine._AbstractGoal;

class GoalNode {
    _AbstractGoal nodeSet;
    long counter;
    long generatedAtStep;

    public GoalNode(EnginePlain engine, _AbstractGoal node) {
        this.nodeSet = node;
        this.counter = engine.LAST_ITERATION_INFO.number_of_generated_nodes++;
        this.generatedAtStep = engine.LAST_ITERATION_INFO.number_of_iterations;
    }

    public String toString() {
        return this.formatAsEngineNode();
    }

    String formatAsRestoredEngineNode() {
        String strNodeSet = this.nodeSet.format();
        strNodeSet = "    | " + strNodeSet.replaceAll("\n", "\n    | ");
        return "(" + this.counter + ") generated at step [" + this.generatedAtStep + "]\n" + strNodeSet;
    }

    String formatAsEngineNode() {
        return "(" + this.counter + ")\n" + VerboseModeSupport.indentWithPrefix("| ", this.nodeSet.format());
    }
}

