/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.DFStack;
import jtabwb.engine.DFStackNode_Branch;
import jtabwb.engine.DFStackNode_BranchExists;
import jtabwb.engine.DFStackNode_MetaBacktrack;
import jtabwb.engine.GoalNode;
import jtabwb.engine.ImplementationError;
import jtabwb.engine.IterationInfo;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.RuleType;
import jtabwb.engine.VerboseModeSupport;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._ClashDetectionRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._OnRuleCompletedListener;
import jtabwb.engine._Prover;
import jtabwb.engine._RegularRule;
import jtabwb.engine._Strategy;

class EnginePlain {
    private final _AbstractRule FORCE_BACKTRACK = new _AbstractRule(){

        @Override
        public String name() {
            return "FORCE_BACKTRACK";
        }
    };
    private final _AbstractRule FORCE_BRANCH_POINT_SEARCH = new _AbstractRule(){

        @Override
        public String name() {
            return "FORCE_BRANCH_POINT_SEARCH";
        }
    };
    _Prover prover;
    _Strategy strategy;
    _AbstractGoal goal;
    DFStack stack;
    ProofSearchResult result = null;
    GoalNode currentGoal;
    final IterationInfo LAST_ITERATION_INFO;
    boolean verboseMode;

    EnginePlain(_Prover prover, _AbstractGoal goal, DFStack stack, boolean verboseMode) {
        this.prover = prover;
        this.goal = goal;
        this.stack = stack;
        this.strategy = prover.getStrategy();
        this.result = null;
        this.currentGoal = null;
        this.verboseMode = verboseMode;
        this.LAST_ITERATION_INFO = new IterationInfo(this);
    }

    EnginePlain(_Prover prover, _AbstractGoal goal, boolean verboseMode) {
        this(prover, goal, null, verboseMode);
        this.stack = new DFStack(this, verboseMode, true);
    }

    private void reset() {
        this.result = null;
        this.currentGoal = null;
        this.stack = this.stack.newInstance();
        this.LAST_ITERATION_INFO.reset();
    }

    _AbstractRule applyRule(_AbstractRule ruleToApply, RuleType ruleType) {
        _AbstractRule result;
        if (this.LAST_ITERATION_INFO.move != IterationInfo.Move.BACKTRACK_POINT_SEARCH && this.LAST_ITERATION_INFO.move != IterationInfo.Move.BRANCH_POINT_SEARCH) {
            this.stack.restored_DFStackNode = null;
        }
        this.LAST_ITERATION_INFO.applied_rule = null;
        this.LAST_ITERATION_INFO.current_node_set_status = null;
        this.LAST_ITERATION_INFO.backtrack_point_added = false;
        this.LAST_ITERATION_INFO.branch_point_added = false;
        this.LAST_ITERATION_INFO.number_of_conclusions = -1;
        this.LAST_ITERATION_INFO.treated_conclusion = -1;
        ++this.LAST_ITERATION_INFO.number_of_iterations;
        this.LAST_ITERATION_INFO.number_of_restored_backtrack_points = this.stack.number_of_restored_backtrack_points;
        this.LAST_ITERATION_INFO.number_of_restored_branch_points = this.stack.number_of_restored_branch_points;
        this.LAST_ITERATION_INFO.max_stack_size = this.stack.max_stack_size;
        if (ruleToApply instanceof _OnRuleCompletedListener) {
            this.stack.addOnCompletedRuleListener((_OnRuleCompletedListener)ruleToApply);
        }
        switch (ruleType) {
            case REGULAR: {
                _RegularRule application = (_RegularRule)ruleToApply;
                if (application.numberOfSubgoals() > 1) {
                    DFStackNode_Branch branchNode = this.stack.addBranchNode(application, this.currentGoal);
                    this.LAST_ITERATION_INFO.branch_point_added = true;
                    this.currentGoal = branchNode.nextConclusionToTreat(this);
                } else {
                    this.currentGoal = new GoalNode(this, application.nextSubgoal());
                }
                this.LAST_ITERATION_INFO.applied_rule = ruleToApply;
                this.LAST_ITERATION_INFO.number_of_conclusions = application.numberOfSubgoals();
                this.LAST_ITERATION_INFO.treated_conclusion = 0;
                this.LAST_ITERATION_INFO.move = IterationInfo.Move.REGULAR_RULE_APPLICATION;
                result = null;
                break;
            }
            case BRANCH_EXISTS: {
                _BranchExistsRule application = (_BranchExistsRule)ruleToApply;
                if (application.numberOfBranchExistsSubgoals() > 1) {
                    DFStackNode_BranchExists dfb = this.stack.addBranchExistsNode(application, this.currentGoal);
                    this.LAST_ITERATION_INFO.backtrack_point_added = true;
                    this.currentGoal = dfb.nextBranchToTreat(this);
                } else {
                    this.currentGoal = new GoalNode(this, application.nextBranchExistsSubgoal());
                }
                this.LAST_ITERATION_INFO.applied_rule = ruleToApply;
                this.LAST_ITERATION_INFO.number_of_conclusions = application.numberOfBranchExistsSubgoals();
                this.LAST_ITERATION_INFO.treated_conclusion = 0;
                this.LAST_ITERATION_INFO.move = IterationInfo.Move.BRANCH_EXISTS_RULE_APPLICATION;
                result = null;
                break;
            }
            case META_BACKTRACK_RULE: {
                _MetaBacktrackRule application = (_MetaBacktrackRule)ruleToApply;
                if (application.totalNumberOfRules() > 1) {
                    DFStackNode_MetaBacktrack backtrackNode = this.stack.addMetaBacktrackNode(application, this.currentGoal);
                    result = backtrackNode.nextRuleToTry();
                    this.LAST_ITERATION_INFO.backtrack_point_added = true;
                } else {
                    result = application.nextRule();
                }
                this.LAST_ITERATION_INFO.applied_rule = ruleToApply;
                this.LAST_ITERATION_INFO.move = IterationInfo.Move.META_RULE_APPLICATION;
                break;
            }
            case CLASH_DETECTION_RULE: {
                _ClashDetectionRule application = (_ClashDetectionRule)ruleToApply;
                this.LAST_ITERATION_INFO.current_node_set_status = application.status();
                this.LAST_ITERATION_INFO.applied_rule = ruleToApply;
                this.LAST_ITERATION_INFO.move = IterationInfo.Move.CLASH_DETECTION_RULE_APPLICATION;
                result = null;
                break;
            }
            case FORCE_BRANCH_FAILURE: {
                result = this.FORCE_BACKTRACK;
                this.LAST_ITERATION_INFO.current_node_set_status = ProofSearchResult.FAILURE;
                this.LAST_ITERATION_INFO.applied_rule = ruleToApply;
                this.LAST_ITERATION_INFO.move = IterationInfo.Move.FORCE_BRANCH_FAILURE_APPLICATION;
                break;
            }
            case FORCE_BRANCH_SUCCESS: {
                result = this.FORCE_BRANCH_POINT_SEARCH;
                this.LAST_ITERATION_INFO.current_node_set_status = ProofSearchResult.SUCCESS;
                this.LAST_ITERATION_INFO.applied_rule = ruleToApply;
                this.LAST_ITERATION_INFO.move = IterationInfo.Move.FORCE_BRANCH_SUCCESS_APPLICATION;
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
            }
        }
        if (this.verboseMode) {
            VerboseModeSupport.printIterationInfo(this.LAST_ITERATION_INFO, this.stack, ruleType, result, this.currentGoal);
        }
        return result;
    }

    _AbstractGoal getLastIterationGeneratedNodeSet() {
        return this.currentGoal == null ? null : this.currentGoal.nodeSet;
    }

    _AbstractGoal getInitialGoal() {
        return this.goal;
    }

    ProofSearchResult getResult() {
        return this.result;
    }

    ProofSearchResult searchProof() {
        if (this.verboseMode) {
            VerboseModeSupport.printInitialSetInfo(this.LAST_ITERATION_INFO, this.stack, this.goal);
        }
        this.reset();
        this.currentGoal = new GoalNode(this, this.goal.clone());
        this.result = null;
        boolean finished = false;
        _AbstractRule nextRule = this.strategy.nextRule(this.currentGoal.nodeSet, this.LAST_ITERATION_INFO);
        while (!finished) {
            if (nextRule != null) {
                RuleType stepType = RuleType.getType(nextRule);
                _AbstractRule returnedRule = this.applyRule(nextRule, stepType);
                switch (stepType) {
                    case META_BACKTRACK_RULE: {
                        nextRule = returnedRule;
                        break;
                    }
                    case FORCE_BRANCH_FAILURE: {
                        nextRule = null;
                        break;
                    }
                    case FORCE_BRANCH_SUCCESS: {
                        this.LAST_ITERATION_INFO.move = IterationInfo.Move.BRANCH_POINT_SEARCH;
                        ++this.LAST_ITERATION_INFO.number_of_iterations;
                        if (this.stack.noMoreBranchPoints()) {
                            if (this.verboseMode) {
                                VerboseModeSupport.printNoMoreBranchPoints();
                            }
                            this.result = ProofSearchResult.SUCCESS;
                            finished = true;
                            break;
                        }
                        nextRule = this.stack.restorePreviousBranchPoint();
                        break;
                    }
                    default: {
                        if (this.LAST_ITERATION_INFO.current_node_set_status == ProofSearchResult.SUCCESS) {
                            this.LAST_ITERATION_INFO.move = IterationInfo.Move.BRANCH_POINT_SEARCH;
                            ++this.LAST_ITERATION_INFO.number_of_iterations;
                            if (this.stack.noMoreBranchPoints()) {
                                if (this.verboseMode) {
                                    VerboseModeSupport.printNoMoreBranchPoints();
                                }
                                this.result = ProofSearchResult.SUCCESS;
                                finished = true;
                                break;
                            }
                            nextRule = this.stack.restorePreviousBranchPoint();
                            break;
                        }
                        nextRule = this.strategy.nextRule(this.currentGoal.nodeSet, this.LAST_ITERATION_INFO);
                        break;
                    }
                }
                continue;
            }
            this.LAST_ITERATION_INFO.move = IterationInfo.Move.BACKTRACK_POINT_SEARCH;
            ++this.LAST_ITERATION_INFO.number_of_iterations;
            if (this.stack.noMoreBacktrackPoints()) {
                if (this.verboseMode) {
                    VerboseModeSupport.printNoMoreBacktrackPoints();
                }
                this.result = ProofSearchResult.FAILURE;
                finished = true;
                continue;
            }
            nextRule = this.stack.restorePreviousBacktrackPoint();
        }
        return this.result;
    }

    String getStackTrace() {
        return this.stack.getStackTrace();
    }
}

