/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.EnginePlain;
import jtabwb.engine.EngineTrace;
import jtabwb.engine.ImplementationError;
import jtabwb.engine.IterationInfo;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.Trace;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._Prover;

public class Engine {
    private EnginePlain realEngine;
    private ExecutionMode currentExecutionMode;

    public Engine(_Prover prover, _AbstractGoal goal, ExecutionMode mode) {
        this.currentExecutionMode = mode;
        switch (mode) {
            case ENGINE_PLAIN: {
                this.realEngine = new EnginePlain(prover, goal, false);
                break;
            }
            case ENGINE_TRACE: {
                this.realEngine = new EngineTrace(prover, goal, false);
                break;
            }
            case ENGINE_VERBOSE: {
                this.realEngine = new EnginePlain(prover, goal, true);
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
            }
        }
    }

    public Engine(_Prover prover, _AbstractGoal goal) {
        this(prover, goal, ExecutionMode.ENGINE_PLAIN);
    }

    public _AbstractGoal getInitialGoal() {
        return this.realEngine.getInitialGoal();
    }

    public ProofSearchResult getResult() {
        return this.realEngine.getResult();
    }

    public Trace getTrace() {
        if (this.currentExecutionMode == ExecutionMode.ENGINE_TRACE) {
            return ((EngineTrace)this.realEngine).getTrace();
        }
        return null;
    }

    public ProofSearchResult searchProof() {
        return this.realEngine.searchProof();
    }

    public IterationInfo getLastIterationInfo() {
        return this.realEngine.LAST_ITERATION_INFO;
    }

    public static enum ExecutionMode {
        ENGINE_PLAIN,
        ENGINE_VERBOSE,
        ENGINE_TRACE;

    }
}

