/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.DFStack;
import jtabwb.engine.DFStackNode_Branch;
import jtabwb.engine.DFStackNode_BranchExists;
import jtabwb.engine.DFStackNode_MetaBacktrack;
import jtabwb.engine.EnginePlain;
import jtabwb.engine.EngineTrace;
import jtabwb.engine.GoalNode;
import jtabwb.engine.ImplementationError;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.RuleType;
import jtabwb.engine.Trace;
import jtabwb.engine.TraceNode;
import jtabwb.engine.TraceStack;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._Prover;
import jtabwb.engine._RegularRule;

class DFStackWithTrace
extends DFStack {
    private int nodeCounter = 0;
    boolean isStackModified = false;
    TraceNode currentTraceNode = null;
    TraceNode headOfTrace = null;
    TraceStack traceStack = new TraceStack();

    public DFStackWithTrace(EngineTrace engine, boolean verboseMode) {
        super(engine, verboseMode, false);
    }

    @Override
    DFStack newInstance() {
        return new DFStackWithTrace((EngineTrace)this.engine, this.verboseMode);
    }

    @Override
    DFStackNode_Branch addBranchNode(_RegularRule rule, GoalNode currentGoal) {
        this.isStackModified = true;
        return super.addBranchNode(rule, currentGoal);
    }

    @Override
    DFStackNode_MetaBacktrack addMetaBacktrackNode(_MetaBacktrackRule rule, GoalNode currentGoal) {
        this.isStackModified = true;
        return super.addMetaBacktrackNode(rule, currentGoal);
    }

    @Override
    DFStackNode_BranchExists addBranchExistsNode(_BranchExistsRule rule, GoalNode currentGoal) {
        this.isStackModified = true;
        return super.addBranchExistsNode(rule, currentGoal);
    }

    void traceRule(EnginePlain engine, _AbstractGoal premiseOfRuleApplication, _AbstractRule rule) {
        TraceNode newTraceNode = new TraceNode(premiseOfRuleApplication, this.traceStack.nodeGeneratingPremise, rule, this.currentTraceNode, this.nodeCounter++);
        if (this.currentTraceNode != null) {
            this.currentTraceNode.addChild(newTraceNode);
        } else {
            this.headOfTrace = newTraceNode;
        }
        this.currentTraceNode = newTraceNode;
        if (this.isStackModified) {
            this.traceStack.pushWithDFStackModified(newTraceNode, this.df_head);
        } else {
            this.traceStack.pushWithDFStackUnchanged(newTraceNode);
        }
        switch (RuleType.getType(rule)) {
            case CLASH_DETECTION_RULE: 
            case FORCE_BRANCH_FAILURE: 
            case FORCE_BRANCH_SUCCESS: {
                newTraceNode.status = engine.LAST_ITERATION_INFO.current_node_set_status;
                break;
            }
            case BRANCH_EXISTS: 
            case META_BACKTRACK_RULE: 
            case REGULAR: {
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
            }
        }
        this.isStackModified = false;
    }

    @Override
    _AbstractRule restorePreviousBranchPoint() {
        this.currentTraceNode = this.traceStack.restoreBranchPoint(this.df_lastBranch);
        _AbstractRule result = super.restorePreviousBranchPoint();
        return result;
    }

    @Override
    _AbstractRule restorePreviousBacktrackPoint() {
        this.currentTraceNode = this.traceStack.restoreBacktrackPoint(this.df_lastBacktrack);
        _AbstractRule result = super.restorePreviousBacktrackPoint();
        return result;
    }

    public Trace getTrace(_AbstractGoal initialNodeSet, _Prover prover, ProofSearchResult result) {
        TraceNode headOfTrace = this.traceStack.closeTrace(result);
        return new Trace(initialNodeSet, prover, headOfTrace, result);
    }
}

