/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.DFStackNode;
import jtabwb.engine.DFStackNode_Branch;
import jtabwb.engine.DFStackNode_BranchExists;
import jtabwb.engine.DFStackNode_MetaBacktrack;
import jtabwb.engine.EnginePlain;
import jtabwb.engine.GoalNode;
import jtabwb.engine.OnCompletedRuleHandler;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.VerboseModeSupport;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._OnRuleCompletedListener;
import jtabwb.engine._RegularRule;

class DFStack {
    boolean verboseMode = true;
    boolean applyOnResume = true;
    int current_stack_size = 0;
    int max_stack_size = 0;
    long number_of_restored_backtrack_points = 0L;
    long number_of_restored_branch_points = 0L;
    DFStackNode restored_DFStackNode;
    DFStackNode df_head;
    DFStackNode df_lastBacktrack;
    DFStackNode df_lastBranch;
    EnginePlain engine;
    OnCompletedRuleHandler onCompletedRuleHandler = new OnCompletedRuleHandler(this);

    DFStack(EnginePlain engine, boolean verboseMode, boolean applyOnResume) {
        this.engine = engine;
        this.verboseMode = verboseMode;
        this.applyOnResume = applyOnResume;
        this.df_head = null;
        this.df_lastBacktrack = null;
        this.df_lastBranch = null;
        this.current_stack_size = 0;
        this.max_stack_size = 0;
        this.number_of_restored_backtrack_points = 0L;
        this.number_of_restored_branch_points = 0L;
        this.restored_DFStackNode = null;
    }

    void clearStack() {
        this.df_head = null;
        this.df_lastBacktrack = null;
        this.df_lastBranch = null;
    }

    boolean noMoreBacktrackPoints() {
        return this.df_lastBacktrack == null;
    }

    boolean noMoreBranchPoints() {
        return this.df_lastBranch == null;
    }

    DFStack newInstance() {
        return new DFStack(this.engine, this.verboseMode, true);
    }

    private void pop(DFStackNode node) {
        this.df_head = node.df_previousNode;
        this.current_stack_size = node.node_height - 1;
        this.df_lastBranch = node.df_previousBranch;
        this.df_lastBacktrack = node.df_previousBacktrack;
    }

    private void push(DFStackNode node) {
        node.node_height = ++this.current_stack_size;
        node.generated_at_iteration = this.engine.LAST_ITERATION_INFO.number_of_iterations;
        node.df_previousNode = this.df_head;
        node.df_previousBranch = this.df_lastBranch;
        node.df_previousBacktrack = this.df_lastBacktrack;
        this.df_head = node;
        this.max_stack_size += this.max_stack_size < this.current_stack_size ? 1 : 0;
    }

    DFStackNode_Branch addBranchNode(_RegularRule regularRuleApplication, GoalNode currentGoal) {
        DFStackNode_Branch node = new DFStackNode_Branch(regularRuleApplication, currentGoal, this.applyOnResume);
        this.push(node);
        this.df_lastBranch = this.df_head;
        return node;
    }

    DFStackNode_MetaBacktrack addMetaBacktrackNode(_MetaBacktrackRule metaBacktrackRuleApplication, GoalNode currentGoal) {
        DFStackNode_MetaBacktrack node = new DFStackNode_MetaBacktrack(metaBacktrackRuleApplication, currentGoal, this.applyOnResume);
        this.push(node);
        this.df_lastBacktrack = this.df_head;
        return node;
    }

    DFStackNode_BranchExists addBranchExistsNode(_BranchExistsRule branchExistsRuleApplication, GoalNode currentGoal) {
        DFStackNode_BranchExists node = new DFStackNode_BranchExists(branchExistsRuleApplication, currentGoal, this.applyOnResume);
        this.push(node);
        this.df_lastBacktrack = this.df_head;
        return node;
    }

    boolean isEmpty() {
        return this.df_head == null;
    }

    _AbstractRule restorePreviousBacktrackPoint() {
        _AbstractRule result;
        DFStackNode activeBacktrackPoint;
        if (this.df_lastBacktrack != null) {
            activeBacktrackPoint = this.df_lastBacktrack;
            boolean continueSearch = true;
            do {
                ++this.number_of_restored_backtrack_points;
                if (activeBacktrackPoint.requireOnResumeInvocation) {
                    activeBacktrackPoint.applyOnResume();
                    if (activeBacktrackPoint.isCompleted()) {
                        activeBacktrackPoint = activeBacktrackPoint.df_previousBacktrack;
                        continueSearch = activeBacktrackPoint != null;
                        continue;
                    }
                    continueSearch = false;
                    continue;
                }
                continueSearch = false;
            } while (continueSearch);
        } else {
            activeBacktrackPoint = null;
        }
        if (activeBacktrackPoint == null) {
            this.onCompletedRuleHandler.notify(ProofSearchResult.FAILURE, 0);
            this.restored_DFStackNode = null;
            this.clearStack();
            result = null;
        } else {
            this.onCompletedRuleHandler.notify(ProofSearchResult.FAILURE, activeBacktrackPoint.node_height);
            this.df_head = activeBacktrackPoint;
            this.df_lastBacktrack = activeBacktrackPoint;
            this.df_lastBranch = activeBacktrackPoint.df_previousBranch;
            this.current_stack_size = activeBacktrackPoint.node_height;
            this.restored_DFStackNode = activeBacktrackPoint;
            if (this.df_head instanceof DFStackNode_MetaBacktrack) {
                DFStackNode_MetaBacktrack restoredNode = (DFStackNode_MetaBacktrack)this.df_head;
                this.restored_DFStackNode = restoredNode;
                this.engine.currentGoal = new GoalNode(this.engine, restoredNode.getGoal());
                _AbstractRule nextStep = restoredNode.nextRuleToTry();
                if (restoredNode.numberOfRulesToTry() == 0) {
                    this.pop(restoredNode);
                }
                result = nextStep;
            } else {
                DFStackNode_BranchExists restoredNode = (DFStackNode_BranchExists)this.df_head;
                this.restored_DFStackNode = restoredNode;
                this.engine.currentGoal = restoredNode.nextBranchToTreat(this.engine);
                if (!restoredNode.hasMoreBranchesTOTreat()) {
                    this.pop(restoredNode);
                }
                result = this.engine.strategy.nextRule(this.engine.currentGoal.nodeSet, this.engine.LAST_ITERATION_INFO);
            }
        }
        if (this.verboseMode) {
            if (result != null) {
                VerboseModeSupport.printResumedBacktrackPointInfo(this.engine, result);
            } else {
                VerboseModeSupport.printIterationDetails(this.engine.LAST_ITERATION_INFO, this);
                VerboseModeSupport.printNoMoreBacktrackPoints();
            }
        }
        return result;
    }

    _AbstractRule restorePreviousBranchPoint() {
        DFStackNode activeBranchPoint;
        if (this.df_lastBranch != null) {
            activeBranchPoint = this.df_lastBranch;
            boolean continueSearch = true;
            do {
                ++this.number_of_restored_branch_points;
                if (activeBranchPoint.requireOnResumeInvocation) {
                    activeBranchPoint.applyOnResume();
                    if (activeBranchPoint.isCompleted()) {
                        activeBranchPoint = activeBranchPoint.df_previousBranch;
                        continueSearch = activeBranchPoint != null;
                        continue;
                    }
                    continueSearch = false;
                    continue;
                }
                continueSearch = false;
            } while (continueSearch);
        } else {
            activeBranchPoint = null;
        }
        _AbstractRule result = null;
        boolean restoredBranchPoint = false;
        if (activeBranchPoint == null) {
            this.onCompletedRuleHandler.notify(ProofSearchResult.SUCCESS, 0);
            this.restored_DFStackNode = null;
            this.clearStack();
        } else {
            restoredBranchPoint = true;
            this.onCompletedRuleHandler.notify(ProofSearchResult.SUCCESS, activeBranchPoint.node_height);
            this.df_head = activeBranchPoint;
            this.df_lastBacktrack = activeBranchPoint.df_previousBacktrack;
            this.df_lastBranch = activeBranchPoint;
            this.current_stack_size = activeBranchPoint.node_height;
            this.restored_DFStackNode = activeBranchPoint;
            DFStackNode_Branch branchNode = (DFStackNode_Branch)this.df_head;
            this.engine.currentGoal = branchNode.nextConclusionToTreat(this.engine);
            if (!branchNode.hasMoreConclusionsToTreat()) {
                this.pop(branchNode);
            }
            result = this.engine.strategy.nextRule(this.engine.currentGoal.nodeSet, this.engine.LAST_ITERATION_INFO);
        }
        if (this.verboseMode) {
            if (restoredBranchPoint) {
                VerboseModeSupport.printResumedBranchPointInfo(this.engine);
            } else {
                VerboseModeSupport.printNoMoreBranchPoints();
            }
        }
        return result;
    }

    void addOnCompletedRuleListener(_OnRuleCompletedListener listener) {
        this.onCompletedRuleHandler.add(listener);
    }

    public String getStackTrace() {
        if (this.df_head == null) {
            return "  <EMPTY>";
        }
        String str = null;
        DFStackNode current = this.df_head;
        do {
            str = str == null ? "" : String.valueOf(str) + "\n";
            str = String.valueOf(str) + "  <" + current.node_height + "> " + current.toString();
        } while ((current = current.df_previousNode) != null);
        return str;
    }
}

