/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula._Sequent;

public class SequentOnArray
implements _Sequent,
Cloneable {
    private static final int ABSENT = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTH = 3;
    private static int NUMBER_OF_FORMULA_TYPE = FormulaType.values().length;
    private int[] sequent;
    private FormulaFactory factory;
    private BitSetOfFormulas[] leftFormulas;
    private BitSetOfFormulas[] rightFormulas;
    private BitSetOfFormulas clashes;

    public SequentOnArray(FormulaFactory factory) {
        this.factory = factory;
        this.sequent = new int[factory.numberOfGeneratedFormulas()];
        this.leftFormulas = new BitSetOfFormulas[NUMBER_OF_FORMULA_TYPE];
        this.rightFormulas = new BitSetOfFormulas[NUMBER_OF_FORMULA_TYPE];
        this.clashes = new BitSetOfFormulas(factory);
    }

    @Override
    public Collection<Formula> getLeftFormulas() {
        LinkedList<Formula> coll = new LinkedList<Formula>();
        BitSetOfFormulas[] bitSetOfFormulasArray = this.leftFormulas;
        int n = this.leftFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            BitSetOfFormulas set = bitSetOfFormulasArray[n2];
            if (set != null) {
                coll.addAll(set.getAllFormulas());
            }
            ++n2;
        }
        return coll.size() == 0 ? null : coll;
    }

    @Override
    public Collection<Formula> getLeftFormulas(FormulaType formulaType) {
        return this.leftFormulas[formulaType.ordinal()] == null ? null : this.leftFormulas[formulaType.ordinal()].getAllFormulas();
    }

    @Override
    public Collection<Formula> getRightFormulas() {
        LinkedList<Formula> coll = new LinkedList<Formula>();
        FormulaType[] formulaTypeArray = FormulaType.values();
        int n = formulaTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FormulaType ft = formulaTypeArray[n2];
            if (this.rightFormulas[ft.ordinal()] != null) {
                coll.addAll(this.rightFormulas[ft.ordinal()].getAllFormulas());
            }
            ++n2;
        }
        return coll.size() == 0 ? null : coll;
    }

    @Override
    public Collection<Formula> getRightFormulas(FormulaType formulaType) {
        return this.rightFormulas[formulaType.ordinal()] == null ? null : this.rightFormulas[formulaType.ordinal()].getAllFormulas();
    }

    @Override
    public void addLeft(Formula wff) {
        int idx = wff.getIndex();
        if (this.sequent[idx] == 1 || this.sequent[idx] == 3) {
            return;
        }
        if (this.sequent[idx] == 2) {
            this.sequent[idx] = 3;
            this.clashes.add(wff);
        } else {
            this.sequent[idx] = 1;
        }
        int type = wff.getFormulaType().ordinal();
        if (this.leftFormulas[type] == null) {
            this.leftFormulas[type] = new BitSetOfFormulas(this.factory);
        }
        this.leftFormulas[type].add(wff);
    }

    @Override
    public void addRight(Formula wff) {
        int idx = wff.getIndex();
        if (this.sequent[idx] == 2 || this.sequent[idx] == 3) {
            return;
        }
        if (this.sequent[idx] == 1) {
            this.sequent[idx] = 3;
            this.clashes.add(wff);
        } else {
            this.sequent[idx] = 2;
        }
        int type = wff.getFormulaType().ordinal();
        if (this.rightFormulas[type] == null) {
            this.rightFormulas[type] = new BitSetOfFormulas(this.factory);
        }
        this.rightFormulas[type].add(wff);
    }

    @Override
    public Formula getLeft(FormulaType formulaType) {
        BitSetOfFormulas set = this.leftFormulas[formulaType.ordinal()];
        return set == null ? null : set.getFirst();
    }

    @Override
    public Formula getRight(FormulaType formulaType) {
        BitSetOfFormulas set = this.rightFormulas[formulaType.ordinal()];
        return set == null ? null : set.getFirst();
    }

    @Override
    public boolean removeLeft(Formula wff) {
        int idx = wff.getIndex();
        if (this.sequent[idx] != 1 && this.sequent[idx] != 3) {
            return false;
        }
        if (this.sequent[idx] == 3) {
            this.sequent[idx] = 2;
            this.clashes.remove(wff);
        } else {
            this.sequent[idx] = 0;
        }
        int type = wff.getFormulaType().ordinal();
        if (this.leftFormulas[type].cardinality() == 1) {
            this.leftFormulas[type] = null;
        } else {
            this.leftFormulas[type].remove(wff);
        }
        return true;
    }

    @Override
    public boolean removeRight(Formula wff) {
        int idx = wff.getIndex();
        if (this.sequent[idx] != 2 && this.sequent[idx] != 3) {
            return false;
        }
        if (this.sequent[idx] == 3) {
            this.sequent[idx] = 1;
            this.clashes.remove(wff);
        } else {
            this.sequent[idx] = 0;
        }
        int type = wff.getFormulaType().ordinal();
        if (this.rightFormulas[type].cardinality() == 1) {
            this.rightFormulas[type] = null;
        } else {
            this.rightFormulas[type].remove(wff);
        }
        return true;
    }

    @Override
    public boolean isIdentityAxiom() {
        return !this.clashes.isEmpty();
    }

    @Override
    public boolean containsLeft(Formula wff) {
        int idx = wff.getIndex();
        return this.sequent[idx] == 1 || this.sequent[idx] == 3;
    }

    @Override
    public boolean containsLeft(FormulaType type) {
        return this.leftFormulas[type.ordinal()] != null;
    }

    @Override
    public boolean containsRight(Formula wff) {
        int idx = wff.getIndex();
        return this.sequent[idx] == 2 || this.sequent[idx] == 3;
    }

    @Override
    public boolean containsRight(FormulaType type) {
        return this.rightFormulas[type.ordinal()] != null;
    }

    @Override
    public boolean isLeftSideEmpty() {
        BitSetOfFormulas[] bitSetOfFormulasArray = this.leftFormulas;
        int n = this.leftFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            BitSetOfFormulas set = bitSetOfFormulasArray[n2];
            if (set != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isRightSideEmpty() {
        BitSetOfFormulas[] bitSetOfFormulasArray = this.rightFormulas;
        int n = this.rightFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            BitSetOfFormulas set = bitSetOfFormulasArray[n2];
            if (set != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.isLeftSideEmpty() && this.isRightSideEmpty();
    }

    @Override
    public SequentOnArray clone() {
        try {
            SequentOnArray cloned = (SequentOnArray)super.clone();
            cloned.sequent = (int[])this.sequent.clone();
            cloned.leftFormulas = new BitSetOfFormulas[NUMBER_OF_FORMULA_TYPE];
            cloned.rightFormulas = new BitSetOfFormulas[NUMBER_OF_FORMULA_TYPE];
            int i = 0;
            while (i < NUMBER_OF_FORMULA_TYPE) {
                if (this.leftFormulas[i] != null) {
                    cloned.leftFormulas[i] = this.leftFormulas[i].clone();
                }
                if (this.rightFormulas[i] != null) {
                    cloned.rightFormulas[i] = this.rightFormulas[i].clone();
                }
                ++i;
            }
            cloned.clashes = this.clashes.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new ImplementationError("Clone not supported: " + e.getMessage());
        }
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        return String.valueOf(this.toString(this.getLeftFormulas())) + "==>\n" + this.toString(this.getRightFormulas());
    }

    private String toString(Collection<Formula> list) {
        if (list == null) {
            return "";
        }
        Iterator<Formula> it = list.iterator();
        String str = it.next().format();
        while (it.hasNext()) {
            str = String.valueOf(str) + ", " + it.next().format();
        }
        return str;
    }

    @Override
    public void stablePart() {
        this.clearRight();
    }

    @Override
    public void clearLeft() {
        int i = 0;
        while (i < this.sequent.length) {
            if (this.sequent[i] == 1 || this.sequent[i] == 3) {
                this.removeLeft(this.factory.getByIndex(i));
            }
            ++i;
        }
    }

    @Override
    public void clearRight() {
        int i = 0;
        while (i < this.sequent.length) {
            if (this.sequent[i] == 2 || this.sequent[i] == 3) {
                this.removeRight(this.factory.getByIndex(i));
            }
            ++i;
        }
    }

    @Override
    public void addLeft(Collection<Formula> formulas) {
        for (Formula wff : formulas) {
            this.addLeft(wff);
        }
    }

    @Override
    public void addRight(Collection<Formula> formulas) {
        for (Formula wff : formulas) {
            this.addRight(wff);
        }
    }

    public FormulaFactory getFormulaFactory() {
        return this.factory;
    }

    @Override
    public Iterator<Formula> leftSideIterator() {
        return this.getLeftFormulas().iterator();
    }

    @Override
    public Iterator<Formula> rigtSideIterator() {
        return this.getRightFormulas().iterator();
    }
}

