/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.PropositionalSubstitution;
import jtabwbx.prop.formula.Substitution;

public final class FormulaProposition
extends Formula {
    private String name;
    private final boolean isTrue;
    private final boolean isFalse;
    private int hash;
    private boolean parentesised;
    private FormulaFactory factory;

    FormulaProposition(FormulaFactory factory, String name, boolean isTrue, boolean isFalse) {
        this.factory = factory;
        this.name = name;
        this.isTrue = isTrue;
        this.isFalse = isFalse;
        this.hash = name.hashCode();
        this.parentesised = false;
    }

    @Override
    public FormulaFactory getFactory() {
        return this.factory;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String shortName() {
        return "propositional variable";
    }

    @Override
    public Formula calculateBooleanSimplification() {
        return this;
    }

    @Override
    public Formula applySubstitution(PropositionalSubstitution subst) {
        Formula newF = (Formula)subst.get(this);
        if (newF != null) {
            return newF;
        }
        return this;
    }

    @Override
    public Formula applySubstitution(Substitution subst) {
        Formula newF = (Formula)subst.get(this);
        if (newF != null) {
            return newF;
        }
        return this;
    }

    @Override
    public Formula applyIntuitionisticPartialSubstitution(Substitution subst) {
        Formula newF = (Formula)subst.get(this);
        if (newF != null) {
            return newF;
        }
        return this;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public PropositionalConnective mainConnective() {
        return null;
    }

    @Override
    public Formula[] immediateSubformulas() {
        return null;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean equals(Object other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.name.equals(((FormulaProposition)other).name);
    }

    @Override
    public String format() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean containsProposition(FormulaProposition proposition) {
        return this == proposition;
    }

    @Override
    public boolean containsTrue() {
        return this.isTrue;
    }

    @Override
    public boolean containsFalse() {
        return this.isFalse;
    }

    @Override
    public boolean isFalse() {
        return this.isFalse;
    }

    @Override
    public boolean isTrue() {
        return this.isTrue;
    }

    @Override
    public boolean isIntuitionisticLocalFormula() {
        return !this.isTrue;
    }

    @Override
    public FormulaType getFormulaType() {
        return FormulaType.ATOMIC_WFF;
    }
}

