/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.Collection;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaProposition;

public class FormulaLatexFormatter {
    private boolean abbr_negation = true;
    private static String[][] replacement = new String[][]{{"_", "\\\\_"}, {"\\$", "\\$"}};

    public String toLatex(Formula[] formulas, String separator) {
        String str = "";
        if (formulas == null) {
            return "";
        }
        int i = 0;
        while (i < formulas.length) {
            str = String.valueOf(str) + this.toLatex(formulas[i]) + (i < formulas.length - 1 ? separator : "");
            ++i;
        }
        return str;
    }

    public String toLatex(Collection<Formula> formulas, String separator) {
        if (formulas == null || formulas.size() == 0) {
            return "";
        }
        return this.toLatex(formulas.toArray(new Formula[formulas.size()]), separator);
    }

    public String toLatex(Formula wff) {
        return this._toLatex(wff, false);
    }

    public String _toLatex(Formula wff, boolean parenthesize) {
        String wffStr;
        if (wff.isAtomic()) {
            parenthesize = false;
            FormulaProposition prop = (FormulaProposition)wff;
            if (prop.isFalse()) {
                return "\\bot";
            }
            if (prop.isTrue()) {
                return "\\top";
            }
            return FormulaLatexFormatter.correctName(wff.format());
        }
        Formula[] subwffs = wff.immediateSubformulas();
        switch (wff.mainConnective()) {
            case AND: {
                wffStr = this.buildBinary(subwffs, " \\land ");
                break;
            }
            case OR: {
                wffStr = this.buildBinary(subwffs, " \\lor ");
                break;
            }
            case NOT: {
                wffStr = " \\neg " + this._toLatex(subwffs[0], true);
                parenthesize = false;
                break;
            }
            case IMPLIES: {
                if (this.abbr_negation && subwffs[1].isFalse()) {
                    wffStr = " \\neg " + this._toLatex(subwffs[0], true);
                    parenthesize = false;
                    break;
                }
                wffStr = this.buildBinary(subwffs, " \\to ");
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(wff.mainConnective().getName());
            }
        }
        if (parenthesize) {
            return "(" + wffStr + ")";
        }
        return wffStr;
    }

    private String buildBinary(Formula[] subwffs, String connective) {
        String str = "";
        int i = 0;
        while (i < subwffs.length) {
            str = String.valueOf(str) + this._toLatex(subwffs[i], true) + (i < subwffs.length - 1 ? connective : " ");
            ++i;
        }
        return str;
    }

    private static String correctName(String name) {
        String result = name;
        int i = 0;
        while (i < replacement.length) {
            result = result.replaceAll(replacement[i][0], replacement[i][1]);
            ++i;
        }
        return result;
    }
}

