/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.basic;

import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.prop.basic._PropositionalFormula;

public enum FormulaType {
    ATOMIC_WFF,
    AND_WFF,
    OR_WFF,
    IMPLIES_WFF,
    NOT_WFF,
    EQ_WFF;


    public static FormulaType getFormulaType(_PropositionalFormula wff) {
        if (wff.isAtomic()) {
            return ATOMIC_WFF;
        }
        switch (wff.mainConnective()) {
            case AND: {
                return AND_WFF;
            }
            case OR: {
                return OR_WFF;
            }
            case IMPLIES: {
                return IMPLIES_WFF;
            }
            case NOT: {
                return NOT_WFF;
            }
            case EQ: {
                return EQ_WFF;
            }
        }
        throw new CaseNotImplementedImplementationError(wff.mainConnective().getName());
    }
}

