/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.evaluation;

import ipl.g3ied.evaluation.ContextualSimplification;
import ipl.g3ied.evaluation.EvaluationValue;
import ipl.g3ied.evaluation._Evaluator;
import ipl.g3ied.sequents.G3iFormulaFactory;
import java.util.HashMap;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class SimplificationEvaluationWithPartialResults
implements _Evaluator {
    private _SingleSuccedentSequent context;
    private G3iFormulaFactory factory;
    private HashMap<Integer, Formula> leftReductionValues;
    private HashMap<Integer, Formula> rightReductionValues;

    public SimplificationEvaluationWithPartialResults(G3iFormulaFactory factory, _SingleSuccedentSequent context) {
        this.factory = factory;
        this.context = context;
        this.leftReductionValues = new HashMap();
        this.rightReductionValues = new HashMap();
    }

    @Override
    public _SingleSuccedentSequent getContext() {
        return this.context;
    }

    @Override
    public EvaluationValue eval(Formula formula) {
        Formula red = this.leftReduction(formula);
        if (red.equals(this.factory.TRUE)) {
            return EvaluationValue.T;
        }
        if (this.rightReduction(red).isIntuitionisticLocalFormula()) {
            return EvaluationValue.F;
        }
        return EvaluationValue.X;
    }

    private Formula leftReduction(Formula wff) {
        Formula value = this.leftReductionValues.get(wff);
        if (value != null) {
            return value;
        }
        Formula result = ContextualSimplification.leftReduction(this.factory, wff, this.context);
        this.leftReductionValues.put(wff.getIndex(), result);
        return result;
    }

    private Formula rightReduction(Formula wff) {
        Formula value = this.rightReductionValues.get(wff);
        if (value != null) {
            return value;
        }
        Formula result = ContextualSimplification.rightReduction(this.factory, wff, this.context);
        this.rightReductionValues.put(wff.getIndex(), result);
        return result;
    }
}

