/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.evaluation;

import ipl.g3ied.evaluation.ContextualSimplification;
import ipl.g3ied.evaluation.EvaluationValue;
import ipl.g3ied.evaluation._Evaluator;
import ipl.g3ied.sequents.G3iFormulaFactory;
import ipl.g3ied.sequents._MarkedSingleSuccedentSequent;
import java.util.HashMap;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class IncrementalEvaluator
implements _Evaluator {
    private G3iFormulaFactory factory;
    private _MarkedSingleSuccedentSequent context;
    private IncrementalEvaluator parent;
    private HashMap<Formula, Formula> leftReductionValues;
    private HashMap<Formula, Formula> rightReductionValues;

    public IncrementalEvaluator(G3iFormulaFactory factory, _MarkedSingleSuccedentSequent context, IncrementalEvaluator parent) {
        this.factory = factory;
        this.context = context;
        this.leftReductionValues = new HashMap();
        this.rightReductionValues = new HashMap();
        this.parent = null;
    }

    @Override
    public _SingleSuccedentSequent getContext() {
        return this.context;
    }

    @Override
    public EvaluationValue eval(Formula formula) {
        Formula left_red = this.leftReduction(formula);
        if (left_red.equals(this.factory.TRUE)) {
            return EvaluationValue.T;
        }
        if (this.rightReduction(left_red).isIntuitionisticLocalFormula()) {
            return EvaluationValue.F;
        }
        return EvaluationValue.X;
    }

    private Formula leftReduction(Formula wff) {
        IncrementalEvaluator eval = this;
        while (eval != null) {
            Formula value = eval.leftReductionValues.get(wff);
            if (value != null) {
                return value;
            }
            eval = eval.parent;
        }
        Formula result = ContextualSimplification.leftReduction(this.factory, wff, this.context);
        this.leftReductionValues.put(wff, result);
        return result;
    }

    private Formula rightReduction(Formula wff) {
        Formula value = this.rightReductionValues.get(wff);
        if (value != null) {
            return value;
        }
        Formula result = ContextualSimplification.rightReduction(this.factory, wff, this.context);
        this.rightReductionValues.put(wff, result);
        return result;
    }
}

