/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.evaluation;

import ipl.g3ied.evaluation.EvaluationValue;
import ipl.g3ied.evaluation.ImplementationError;
import ipl.g3ied.evaluation._Evaluator;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula._SingleSuccedentSequent;

public class CoverEvaluation
implements _Evaluator {
    private _SingleSuccedentSequent context;

    public CoverEvaluation(_SingleSuccedentSequent context) {
        this.context = context;
    }

    @Override
    public _SingleSuccedentSequent getContext() {
        return this.context;
    }

    private boolean cover(_SingleSuccedentSequent context, Formula formula) {
        if (context.containsLeft(formula)) {
            return true;
        }
        if (formula.isAtomic()) {
            return false;
        }
        Formula left = formula.immediateSubformulas()[0];
        Formula right = formula.immediateSubformulas()[1];
        switch (formula.mainConnective()) {
            case AND: {
                return this.cover(context, left) && this.cover(context, right);
            }
            case OR: {
                return this.cover(context, left) || this.cover(context, right);
            }
            case IMPLIES: {
                return this.cover(context, right);
            }
        }
        throw new ImplementationError();
    }

    private boolean negCover(_SingleSuccedentSequent context, Formula formula) {
        if (context.containsLeft(formula)) {
            return false;
        }
        if (formula.isAtomic()) {
            return true;
        }
        Formula left = formula.immediateSubformulas()[0];
        Formula right = formula.immediateSubformulas()[1];
        switch (formula.mainConnective()) {
            case AND: {
                return this.negCover(context, left) || this.negCover(context, right);
            }
            case OR: {
                return this.negCover(context, left) && this.negCover(context, right);
            }
            case IMPLIES: {
                return this.cover(context, left) && this.negCover(context, right);
            }
        }
        throw new ImplementationError();
    }

    @Override
    public EvaluationValue eval(Formula formula) {
        if (this.cover(this.context, formula)) {
            return EvaluationValue.T;
        }
        if (this.negCover(this.context, formula)) {
            return EvaluationValue.F;
        }
        return EvaluationValue.X;
    }
}

