/*
 * Decompiled with CFR 0.152.
 */
package ipl.g3ied.evaluation;

import ferram.rtoptions._NamedArgument;
import ipl.g3ied.evaluation.CoverEvaluationFactory;
import ipl.g3ied.evaluation.ImplementationError;
import ipl.g3ied.evaluation.MinimalEvaluationFactory;
import ipl.g3ied.evaluation.SimplificationEvaluationFactory;
import ipl.g3ied.evaluation.SimplificationEvaluationWithPartialResultsFactory;
import ipl.g3ied.evaluation._EvaluationFactory;
import ipl.g3ied.sequents.G3iFormulaFactory;

public enum AvailableEvaluations implements _NamedArgument<AvailableEvaluations>
{
    MINIMAL("min", "Minimal...."),
    COVER("cover", "Cover"),
    SIMPLIFICATION_EVALUATION("simpl", "Simplification evaluation [FerFioFio:TOCL:2014]"),
    SIMPLIFICATION_EVALUATION_WITH_PARTIAL_RESULTS("prsimpl", "Simplification evaluation with partial results [FerFioFio:TOCL:2014]");

    private String name;
    private String description;

    private AvailableEvaluations(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public AvailableEvaluations getValue() {
        return this;
    }

    public static _EvaluationFactory getEvaluationFactory(AvailableEvaluations eval, G3iFormulaFactory formulaFactory) {
        switch (eval) {
            case COVER: {
                return new CoverEvaluationFactory();
            }
            case MINIMAL: {
                return new MinimalEvaluationFactory(formulaFactory);
            }
            case SIMPLIFICATION_EVALUATION: {
                return new SimplificationEvaluationFactory();
            }
            case SIMPLIFICATION_EVALUATION_WITH_PARTIAL_RESULTS: {
                return new SimplificationEvaluationWithPartialResultsFactory();
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }
}

