/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwb.util.ContractViolationImplementationError;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.btformula.BTFormula;
import jtabwbx.prop.btformula.BTFormulaProposition;
import jtabwbx.prop.formula.AbstractCompoundFormula;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaAnd;
import jtabwbx.prop.formula.FormulaIff;
import jtabwbx.prop.formula.FormulaImplies;
import jtabwbx.prop.formula.FormulaNot;
import jtabwbx.prop.formula.FormulaOr;
import jtabwbx.prop.formula.FormulaProposition;
import jtabwbx.prop.formula.FromParseTreeFormulaBuilder;
import jtabwbx.prop.formula.GDebugInfo;
import org.antlr.v4.runtime.tree.ParseTree;

public class FormulaFactory {
    private final Map<String, FormulaProposition> propositions;
    private final Map<AbstractCompoundFormula, AbstractCompoundFormula> formulaCompounds;
    private final ArrayList<Formula> formulasByIndex;
    private BitSetOfFormulas[] formulasByType;
    private BitSetOfFormulas generatedFormulas;
    private int formulaCounter;
    boolean translateNot = false;
    boolean translateIff = false;
    boolean translateImpliesFalse = false;
    private String FALSE_NAME = "false";
    private String TRUE_NAME = "true";
    public final FormulaProposition FALSE;
    public final FormulaProposition TRUE;
    BitSetOfFormulas intuitionisticNonLocalFormulas;

    public FormulaFactory(String falseName, String trueName) {
        if (trueName.equals(falseName)) {
            throw new ContractViolationImplementationError("Names for false and true constants must be different.");
        }
        this.formulaCounter = 0;
        this.propositions = new HashMap<String, FormulaProposition>(100, 0.5f);
        this.formulaCompounds = new HashMap<AbstractCompoundFormula, AbstractCompoundFormula>(100, 0.5f);
        this.formulasByIndex = new ArrayList(50);
        this.generatedFormulas = new BitSetOfFormulas(this);
        this.formulasByType = new BitSetOfFormulas[FormulaType.values().length];
        int i = 0;
        while (i < this.formulasByType.length) {
            this.formulasByType[i] = new BitSetOfFormulas(this);
            ++i;
        }
        this.intuitionisticNonLocalFormulas = new BitSetOfFormulas(this);
        this.FALSE_NAME = falseName;
        this.FALSE = this.buildAtomic(this.FALSE_NAME);
        this.TRUE_NAME = trueName;
        this.TRUE = this.buildAtomic(this.TRUE_NAME);
    }

    public FormulaFactory() {
        this("false", "true");
    }

    public int numberOfGeneratedFormulas() {
        return this.formulaCounter;
    }

    public ArrayList<Formula> generatedFormulas() {
        return (ArrayList)this.formulasByIndex.clone();
    }

    public FormulaProposition getTrue() {
        return this.TRUE;
    }

    public FormulaProposition getFalse() {
        return this.FALSE;
    }

    public BitSetOfFormulas getGeneratedFormula() {
        return this.generatedFormulas;
    }

    public BitSetOfFormulas getGeneratedFormulasOfType(FormulaType type) {
        return this.formulasByType[type.ordinal()];
    }

    public FormulaProposition buildAtomic(String name) {
        FormulaProposition newProp = this.propositions.get(name);
        if (newProp == null) {
            newProp = new FormulaProposition(this, name, name.equals(this.TRUE_NAME), name.equals(this.FALSE_NAME));
            newProp.size = 1;
            this.propositions.put(name, newProp);
            newProp.setIndex(this.formulaCounter++);
            this.formulasByIndex.add(newProp);
            this.generatedFormulas.add(newProp);
            this.formulasByType[newProp.getFormulaType().ordinal()].add(newProp);
            if (!newProp.isIntuitionisticLocalFormula()) {
                this.intuitionisticNonLocalFormulas.add(newProp);
            }
        }
        return newProp;
    }

    public Formula buildCompound(PropositionalConnective mainConnective, Formula ... subFormulas) {
        PropositionalConnective connective = mainConnective;
        try {
            AbstractCompoundFormula newFormula;
            if (connective == PropositionalConnective.NOT) {
                newFormula = this.translateNot ? new FormulaImplies(this, subFormulas[0], this.FALSE) : new FormulaNot(this, subFormulas[0]);
            } else {
                Formula left = subFormulas[0];
                Formula right = subFormulas[1];
                switch (connective) {
                    case IMPLIES: {
                        if (this.translateImpliesFalse && right.equals(this.FALSE)) {
                            newFormula = new FormulaNot(this, left);
                            break;
                        }
                        newFormula = new FormulaImplies(this, left, right);
                        break;
                    }
                    case EQ: {
                        if (this.translateIff) {
                            Formula leftToRight = this.buildCompound(PropositionalConnective.IMPLIES, left, right);
                            Formula rightToLeft = this.buildCompound(PropositionalConnective.IMPLIES, right, left);
                            newFormula = new FormulaAnd(this, leftToRight, rightToLeft);
                            break;
                        }
                        newFormula = new FormulaIff(this, left, right);
                        break;
                    }
                    case AND: {
                        newFormula = new FormulaAnd(this, left, right);
                        break;
                    }
                    case OR: {
                        newFormula = new FormulaOr(this, left, right);
                        break;
                    }
                    default: {
                        throw new CaseNotImplementedImplementationError(connective.getName());
                    }
                }
            }
            return this.getCanonicalFormula(newFormula);
        }
        catch (ClassCastException e) {
            throw new ImplementationError("Wrong subformula type: " + e.getMessage());
        }
    }

    private AbstractCompoundFormula getCanonicalFormula(AbstractCompoundFormula newFormula) {
        AbstractCompoundFormula canonicalFormula = this.formulaCompounds.get(newFormula);
        if (canonicalFormula == null) {
            this.formulaCompounds.put(newFormula, newFormula);
            canonicalFormula = newFormula;
            canonicalFormula.setIndex(this.formulaCounter++);
            this.formulasByIndex.add(canonicalFormula);
            this.generatedFormulas.add(canonicalFormula);
            this.formulasByType[canonicalFormula.getFormulaType().ordinal()].add(canonicalFormula);
            if (!canonicalFormula.isIntuitionisticLocalFormula()) {
                this.intuitionisticNonLocalFormulas.add(canonicalFormula);
            }
        }
        return canonicalFormula;
    }

    public Formula getByIndex(int index) {
        return this.formulasByIndex.get(index);
    }

    public Formula buildFrom(Formula wff) {
        if (wff.isAtomic()) {
            return this.buildAtomic(((FormulaProposition)wff).getName());
        }
        PropositionalConnective mainConnective = wff.mainConnective();
        switch (mainConnective) {
            case AND: 
            case OR: 
            case IMPLIES: 
            case EQ: {
                Formula left = this.buildFrom(wff.immediateSubformulas()[0]);
                Formula right = this.buildFrom(wff.immediateSubformulas()[1]);
                return this.buildCompound(mainConnective, left, right);
            }
            case NOT: {
                return this.buildCompound(mainConnective, this.buildFrom(wff.immediateSubformulas()[0]));
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }

    public Formula buildFrom(BTFormula wff) {
        if (wff.isAtomic()) {
            return this.buildAtomic(((BTFormulaProposition)wff).getName());
        }
        PropositionalConnective mainConnective = wff.mainConnective();
        Formula translation = null;
        switch (mainConnective) {
            case AND: 
            case OR: 
            case IMPLIES: 
            case EQ: {
                Formula left = this.buildFrom(wff.immediateSubformulas()[0]);
                Formula right = this.buildFrom(wff.immediateSubformulas()[1]);
                translation = this.buildCompound(mainConnective, left, right);
                break;
            }
            case NOT: {
                translation = this.buildCompound(mainConnective, this.buildFrom(wff.immediateSubformulas()[0]));
                break;
            }
            default: {
                throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
            }
        }
        return translation;
    }

    public Formula buildFrom(ParseTree parseTree) {
        FromParseTreeFormulaBuilder builder = new FromParseTreeFormulaBuilder(this);
        return builder.buildFrom(parseTree);
    }

    public BitSetOfFormulas intuitionisticNonLocalFormulas() {
        return this.intuitionisticNonLocalFormulas;
    }

    public String getDescription() {
        return "Factory for propositional formulas.";
    }

    public void setTranslateNegations(boolean b) {
        this.translateNot = b;
    }

    public void setTranslateEquivalences(boolean b) {
        this.translateIff = b;
    }

    public void setTranslateImplisesFalse(boolean b) {
        this.translateImpliesFalse = b;
    }

    public String toString() {
        return String.format("GFormulaFactory:\n propositions: %d\n formulaCompounds: %d", this.propositions.size(), this.formulaCompounds.size());
    }

    GDebugInfo getDebugInfo() {
        GDebugInfo info = new GDebugInfo(this.propositions.size(), this.formulaCompounds.size());
        return info;
    }
}

