/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.prop.btformula;

import java.util.HashMap;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.btformula.BTFormula;
import jtabwbx.prop.btformula.BTFormulaCompound;
import jtabwbx.prop.btformula.BTFormulaProposition;
import jtabwbx.prop.btformula.ImplementationError;

public class BTPropositionalFormulaFactory {
    private HashMap<String, BTFormulaProposition> varManager = new HashMap();
    public static final BTFormulaProposition FALSE = BTFormulaProposition.FALSE;
    public static final BTFormulaProposition TRUE = BTFormulaProposition.TRUE;

    public BTPropositionalFormulaFactory() {
        this.varManager.put(TRUE.getName(), TRUE);
        this.varManager.put(FALSE.getName(), FALSE);
    }

    public BTFormula buildAtomic(String name) {
        BTFormulaProposition prop = this.varManager.get(name);
        if (prop == null) {
            prop = new BTFormulaProposition(name);
            this.varManager.put(name, prop);
        }
        return prop;
    }

    public BTFormula buildCompound(PropositionalConnective mainConnective, BTFormula ... subformulas) {
        if (subformulas == null ? mainConnective.arity() != 0 : subformulas.length != mainConnective.arity()) {
            throw new ImplementationError("Wrong number of subformulas");
        }
        try {
            BTFormulaCompound wff;
            switch (mainConnective) {
                case NOT: {
                    wff = new BTFormulaCompound(mainConnective, subformulas[0]);
                    break;
                }
                case AND: 
                case OR: 
                case IMPLIES: 
                case EQ: {
                    wff = new BTFormulaCompound(mainConnective, subformulas[0], subformulas[1]);
                    break;
                }
                default: {
                    throw new ImplementationError();
                }
            }
            return wff;
        }
        catch (ClassCastException e) {
            throw new ImplementationError("Wrong logical constant: " + mainConnective.getName() + this.getClass().toString());
        }
    }

    public String getDescription() {
        return null;
    }
}

