/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.problems;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import jtabwb.launcher.ProblemDescriptionException;
import jtabwb.util.CaseNotImplementedImplementationError;
import jtabwbx.problems.ILTPProblem;
import jtabwbx.problems.ILTPProblemBuilder;
import jtabwbx.problems.ILTPProblemLexer;
import jtabwbx.problems.ILTPProblemParserError;
import jtabwbx.problems.Log;
import jtabwbx.prop.formula.Formula;

class ILTProblemParser {
    private final ILTPProblemLexer lexer;
    private ILTPProblemLexer.Token currentToken;
    private ILTPProblemBuilder problemBuilder;
    private final InfoLineExtractor infoLineExtractor;

    public ILTProblemParser(String filename) throws FileNotFoundException {
        this(new FileReader(filename));
    }

    public ILTProblemParser(Reader reader) {
        this.lexer = new ILTPProblemLexer(reader);
        this.currentToken = this.lexer.nextToken();
        this.problemBuilder = new ILTPProblemBuilder();
        this.infoLineExtractor = new InfoLineExtractor();
    }

    public ILTPProblem parse() throws ILTPProblemParserError, ProblemDescriptionException {
        this.start();
        return this.problemBuilder.build();
    }

    private void start() throws ILTPProblemParserError, ProblemDescriptionException {
        while (this.currentToken.getType() != ILTPProblemLexer.TokenType.EOF) {
            this.infoCommentOrProblemDescription();
        }
    }

    private void infoCommentOrProblemDescription() throws ILTPProblemParserError, ProblemDescriptionException {
        if (this.currentToken.getType() == ILTPProblemLexer.TokenType.INFO_COMMENT) {
            this.infoComment();
        } else {
            this.fof();
        }
    }

    private void infoComment() throws ProblemDescriptionException {
        InfoLineExtractor.InfoLineResult info = this.infoLineExtractor.extract(this.currentToken.getText());
        switch (info.type) {
            case FILE: {
                this.problemBuilder.setProblemName(info.text);
                break;
            }
            case STATUS: {
                this.problemBuilder.setProblemStatus(info.text);
                break;
            }
            case IGNORE: {
                break;
            }
            default: {
                throw new CaseNotImplementedImplementationError(info.type.name());
            }
        }
        this.consumeToken();
    }

    private void fof() throws ILTPProblemParserError {
        this.match(Terminal.KEY_FOF);
        this.match(Terminal.SEP_LEFTPAR);
        String fof_name = this.IDENTIFIER();
        this.match(Terminal.SEP_COMMA);
        Terminal formula_role = this.match((Terminal[])new Terminal[]{Terminal.KEY_AXIOM, Terminal.KEY_CONJECTURE}).terminal;
        this.match(Terminal.SEP_COMMA);
        Formula formula = this.formula();
        this.match(Terminal.SEP_RIGHTPAR);
        this.match(Terminal.SEP_DOT);
        this.problemBuilder.addFormula(formula_role, fof_name, formula);
    }

    private Formula formula() throws ILTPProblemParserError {
        Terminal lookahead = this.lookhead(Terminal.SEP_LEFTPAR, Terminal.ID, Terminal.OP_NOT);
        switch (lookahead) {
            case ID: {
                return this.atomicFormula();
            }
            case OP_NOT: {
                this.match(Terminal.OP_NOT);
                Formula subf = this.formula();
                return this.problemBuilder.buildUnary(lookahead, subf);
            }
            case SEP_LEFTPAR: {
                return this.compoundFormula();
            }
        }
        throw new CaseNotImplementedImplementationError(lookahead.name());
    }

    private Formula atomicFormula() throws ILTPProblemParserError {
        String name = this.match((Terminal[])new Terminal[]{Terminal.ID}).text;
        return this.problemBuilder.buildAtomic(name);
    }

    private Formula compoundFormula() throws ILTPProblemParserError {
        this.match(Terminal.SEP_LEFTPAR);
        Formula subf1 = this.formula();
        Terminal lookahead = this.lookhead(Terminal.SEP_RIGHTPAR, Terminal.OP_AND, Terminal.OP_OR, Terminal.OP_IMPLIES, Terminal.OP_EQ);
        switch (lookahead) {
            case SEP_RIGHTPAR: {
                this.match(Terminal.SEP_RIGHTPAR);
                return subf1;
            }
        }
        this.match(lookahead);
        Formula subf2 = this.formula();
        this.match(Terminal.SEP_RIGHTPAR);
        return this.problemBuilder.buildBinary(lookahead, subf1, subf2);
    }

    private String IDENTIFIER() throws ILTPProblemParserError {
        String result = this.currentToken.getText();
        this.match(Terminal.ID);
        return result;
    }

    private MatchResult match(Terminal ... terminals) throws ILTPProblemParserError {
        Terminal[] terminalArray = terminals;
        int n = terminals.length;
        int n2 = 0;
        while (n2 < n) {
            Terminal terminal = terminalArray[n2];
            if (terminal.checkToken(this.currentToken)) {
                MatchResult result = new MatchResult(terminal, this.currentToken.getText());
                this.currentToken = this.lexer.nextToken();
                return result;
            }
            ++n2;
        }
        throw new ILTPProblemParserError(this.matchErrorString(terminals));
    }

    private Terminal lookhead(Terminal ... terminals) throws ILTPProblemParserError {
        Terminal[] terminalArray = terminals;
        int n = terminals.length;
        int n2 = 0;
        while (n2 < n) {
            Terminal terminal = terminalArray[n2];
            if (terminal.checkToken(this.currentToken)) {
                return terminal;
            }
            ++n2;
        }
        throw new ILTPProblemParserError(this.matchErrorString(terminals));
    }

    private String matchErrorString(Terminal ... terminals) {
        if (terminals.length == 1) {
            return String.format("Found \"%s\" expecting %s", this.currentToken.getText(), terminals[0].getLexeme());
        }
        String expecting = "";
        int i = 0;
        while (i < terminals.length) {
            expecting = String.valueOf(expecting) + String.format("%s", terminals[i].getLexeme()) + (i < terminals.length - 1 ? " " : "");
            ++i;
        }
        return expecting;
    }

    private void consumeToken() {
        this.currentToken = this.lexer.nextToken();
    }

    public static void main(String[] args) {
        Log log = new Log();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            log.infoNoLn(String.format("File [%s]... ", filename));
            try {
                ILTProblemParser parser = new ILTProblemParser(filename);
                long start = System.currentTimeMillis();
                ILTPProblem pd = parser.parse();
                long end = System.currentTimeMillis();
                log.info(String.format("parsing time %s", ILTProblemParser.buildTimeString(end - start)));
            }
            catch (FileNotFoundException e) {
                log.error(String.format("File not found: %s", args[0]));
            }
            catch (ILTPProblemParserError e) {
                log.error(String.format("PARSER ERROR: %s", e.getMessage()));
            }
            catch (ProblemDescriptionException e) {
                log.error(String.format("PARSER ERROR: %s", e.getMessage()));
            }
            ++n2;
        }
    }

    private static String buildTimeString(long miliSeconds) {
        int sec = (int)TimeUnit.MILLISECONDS.toSeconds(miliSeconds);
        int mil = (int)miliSeconds % 1000;
        return String.format("%d.%03d seconds", sec, mil);
    }

    static class InfoLineExtractor {
        private final String FILE = "File";
        private final String STATUS = "Status";
        private final String INTUITIONISTIC = "(intuit.)";
        private final String SEPARATOR = "%-";

        InfoLineResult extract(String infoLine) {
            if (infoLine.startsWith("%-")) {
                return new InfoLineResult(InfoLineType.IGNORE, infoLine);
            }
            String toAnalyze = infoLine.substring(1).trim();
            if (toAnalyze.length() == 0) {
                return new InfoLineResult(InfoLineType.IGNORE, infoLine);
            }
            StringTokenizer stk = new StringTokenizer(toAnalyze, " ");
            String token = stk.nextToken();
            if (token.equals("File")) {
                stk.nextToken();
                String name = stk.nextToken();
                return new InfoLineResult(InfoLineType.FILE, name);
            }
            if (token.equals("Status")) {
                String s = stk.nextToken();
                if (!s.equals("(intuit.)")) {
                    return new InfoLineResult(InfoLineType.IGNORE, infoLine);
                }
                stk.nextToken();
                String status = stk.nextToken();
                return new InfoLineResult(InfoLineType.STATUS, status);
            }
            return new InfoLineResult(InfoLineType.IGNORE, infoLine);
        }

        static class InfoLineResult {
            final String text;
            final InfoLineType type;

            public InfoLineResult(InfoLineType type, String text) {
                this.text = text;
                this.type = type;
            }
        }

        static enum InfoLineType {
            FILE,
            STATUS,
            IGNORE;

        }
    }

    private static class MatchResult {
        final Terminal terminal;
        final String text;

        public MatchResult(Terminal terminal, String text) {
            this.text = text;
            this.terminal = terminal;
        }
    }

    static enum Terminal {
        KEY_FOF("fof", ILTPProblemLexer.TokenType.LOWER_NAME),
        KEY_AXIOM("axiom", ILTPProblemLexer.TokenType.LOWER_NAME),
        KEY_CONJECTURE("conjecture", ILTPProblemLexer.TokenType.LOWER_NAME),
        OP_AND("&", ILTPProblemLexer.TokenType.OPERATOR),
        OP_EQ("<=>", ILTPProblemLexer.TokenType.OPERATOR),
        OP_OR("|", ILTPProblemLexer.TokenType.OPERATOR),
        OP_NOT("~", ILTPProblemLexer.TokenType.OPERATOR),
        OP_IMPLIES("=>", ILTPProblemLexer.TokenType.OPERATOR),
        SEP_DOT(".", ILTPProblemLexer.TokenType.SEPARATOR),
        SEP_COMMA(",", ILTPProblemLexer.TokenType.SEPARATOR),
        SEP_LEFTPAR("(", ILTPProblemLexer.TokenType.SEPARATOR),
        SEP_RIGHTPAR(")", ILTPProblemLexer.TokenType.SEPARATOR),
        INFO_COMMENT(null, ILTPProblemLexer.TokenType.INFO_COMMENT),
        ID(null, ILTPProblemLexer.TokenType.LOWER_NAME),
        EOF(null, ILTPProblemLexer.TokenType.EOF);

        private final String lexeme;
        private final ILTPProblemLexer.TokenType requiredTokenType;

        private Terminal(String lexeme, ILTPProblemLexer.TokenType requiredTokenType) {
            this.lexeme = lexeme;
            this.requiredTokenType = requiredTokenType;
        }

        public String getLexeme() {
            return this.lexeme;
        }

        boolean checkToken(ILTPProblemLexer.Token token) {
            if (this.requiredTokenType != token.getType()) {
                return false;
            }
            switch (this) {
                case ID: 
                case EOF: {
                    return true;
                }
            }
            return this.lexeme.equals(token.getText());
        }
    }
}

