/*
 * Decompiled with CFR 0.152.
 */
package jtabwbx.modal.formula;

import java.util.HashSet;
import jtabwbx.modal.basic.ModalConnective;
import jtabwbx.modal.basic.ModalFormulaType;
import jtabwbx.modal.formula.ModalFormula;
import jtabwbx.modal.formula.ModalFormulaFactory;
import jtabwbx.modal.formula.ModalFormulaProposition;

abstract class AbstractCompoundModalFormula
extends ModalFormula {
    static final ModalFormula NULL_FORMULA = new ModalFormula(){

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public boolean containsTrue() {
            return false;
        }

        @Override
        public boolean containsFalse() {
            return false;
        }

        @Override
        public boolean containsProposition(ModalFormulaProposition name) {
            return false;
        }

        @Override
        public boolean isAtomic() {
            return false;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public ModalFormulaType getFormulaType() {
            return null;
        }

        @Override
        public ModalConnective mainConnective() {
            return null;
        }

        @Override
        public ModalFormula[] immediateSubformulas() {
            return null;
        }

        @Override
        public String shortName() {
            return "NullFormula";
        }

        @Override
        public String format() {
            return this.toString();
        }

        public String toString() {
            return "NullFormula, used to unify unary and binary formulae methods";
        }

        @Override
        public boolean isFalse() {
            return false;
        }

        @Override
        public boolean isTrue() {
            return false;
        }

        @Override
        public ModalFormulaFactory getFactory() {
            return null;
        }
    };
    private HashSet<ModalFormulaProposition> propositions;
    private HashSet<ModalFormula> formulae;
    private final int hash;
    private ModalConnective mainConnective;
    protected final ModalFormulaFactory formulaFactory;
    protected final ModalFormula[] subFormulas;
    protected final ModalFormula left;
    protected final ModalFormula right;

    protected AbstractCompoundModalFormula(ModalFormulaFactory formulaFactory, ModalConnective mainConnective, ModalFormula[] subFormulas, ModalFormula left, ModalFormula right) {
        this.formulaFactory = formulaFactory;
        this.mainConnective = mainConnective;
        this.subFormulas = subFormulas;
        this.left = left;
        this.right = right;
        this.propositions = null;
        this.hash = this.computeHashCode(subFormulas);
    }

    @Override
    public final ModalFormulaFactory getFactory() {
        return this.formulaFactory;
    }

    @Override
    public ModalConnective mainConnective() {
        return this.mainConnective;
    }

    @Override
    public String shortName() {
        return String.valueOf(this.mainConnective.getName()) + "-formula";
    }

    private void updateHashSetsIfNeeded() {
        if (this.propositions == null) {
            this.propositions = new HashSet();
            this.formulae = new HashSet();
            ModalFormula[] modalFormulaArray = this.subFormulas;
            int n = this.subFormulas.length;
            int n2 = 0;
            while (n2 < n) {
                ModalFormula sub = modalFormulaArray[n2];
                if (sub instanceof ModalFormulaProposition) {
                    ModalFormulaProposition f = (ModalFormulaProposition)sub;
                    this.propositions.add(f);
                } else {
                    AbstractCompoundModalFormula subCompound = (AbstractCompoundModalFormula)sub;
                    subCompound.updateHashSetsIfNeeded();
                    this.propositions.addAll(subCompound.propositions);
                    this.formulae.add(subCompound);
                    this.formulae.addAll(subCompound.formulae);
                }
                ++n2;
            }
        }
    }

    @Override
    public ModalFormula[] immediateSubformulas() {
        return this.subFormulas;
    }

    @Override
    public final boolean isAtomic() {
        return false;
    }

    @Override
    public final boolean isCompound() {
        return true;
    }

    @Override
    public final boolean isFalse() {
        return false;
    }

    @Override
    public final boolean isTrue() {
        return false;
    }

    public final int hashCode() {
        return this.hash;
    }

    @Override
    public final boolean containsProposition(ModalFormulaProposition proposition) {
        this.updateHashSetsIfNeeded();
        return this.propositions.contains(proposition);
    }

    @Override
    public final boolean containsTrue() {
        return this.containsProposition(this.formulaFactory.getTrue());
    }

    @Override
    public final boolean containsFalse() {
        return this.containsProposition(this.formulaFactory.getFalse());
    }

    public boolean equals(Object o) {
        boolean pair;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCompoundModalFormula that = (AbstractCompoundModalFormula)o;
        boolean bl = pair = this.left == that.left && this.right == that.right;
        return pair || this.left == that.right && this.right == that.left;
    }

    @Override
    public String format() {
        return this.toString();
    }

    public String toString() {
        String formula = String.valueOf(this.left.toString()) + " " + this.mainConnective().toString() + " " + this.right.toString();
        return "(" + formula + ")";
    }

    protected int computeHashCode(ModalFormula[] subFormulas) {
        int result = this.mainConnective().hashCode();
        int leftHash = this.subFormulas[0].hashCode();
        int rightHash = this.subFormulas[1].hashCode();
        result = 31 * result + Math.min(leftHash, rightHash);
        result = 31 * result + Math.max(leftHash, rightHash);
        return result;
    }
}

