/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.tracesupport;

import java.util.Iterator;
import jtabwb.engine.IterationInfo;
import jtabwb.engine.RuleType;
import jtabwb.engine.Trace;
import jtabwb.engine.TraceNode;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._RegularRule;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport.ImplementationError;
import jtabwb.tracesupport._TraceManager;

class ValidatorStrategy
implements _Strategy {
    private Iterator<TraceNode> iterator;
    private _TraceManager traceManager;

    public ValidatorStrategy(Trace trace, _TraceManager tracemanager) {
        this.traceManager = tracemanager;
        this.iterator = trace.iterator();
    }

    @Override
    public _AbstractRule nextRule(_AbstractGoal node, IterationInfo lastIteration) {
        if (this.iterator.hasNext()) {
            _AbstractRule rule = this.iterator.next().getAppliedRule();
            switch (RuleType.getType(rule)) {
                case CLASH_DETECTION_RULE: {
                    return this.traceManager.getRuleByName(rule.name(), node, null);
                }
                case REGULAR: {
                    return this.traceManager.getRuleByName(rule.name(), node, ((_RegularRule)rule).mainFormula());
                }
                case BRANCH_EXISTS: {
                    return this.traceManager.getRuleByName(rule.name(), node, ((_RegularRule)rule).mainFormula());
                }
                case META_BACKTRACK_RULE: {
                    return this.traceManager.getRuleByName(rule.name(), node, null);
                }
            }
            throw new ImplementationError();
        }
        return null;
    }
}

