/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.launcher;

import java.util.HashMap;
import java.util.LinkedList;
import jtabwb.engine.ProvabilityStatus;

public class ProblemDescription {
    private String problemName;
    private HashMap<String, LinkedList<String>> formulasByRole;
    private LinkedList<String> roles;
    private ProvabilityStatus status;
    private String source;

    public ProblemDescription(String name, String inputSource) {
        this.problemName = name;
        this.source = inputSource;
        this.formulasByRole = new HashMap();
        this.roles = new LinkedList();
    }

    public ProblemDescription(String name) {
        this(name, null);
    }

    public ProblemDescription() {
        this(null, null);
    }

    public LinkedList<String> getFormulasByRole(String role) {
        return this.formulasByRole.get(role);
    }

    public LinkedList<String> getRoles() {
        return this.roles;
    }

    public void add(String role, String formula) {
        if (this.roles.contains(role)) {
            LinkedList<String> formulas = this.formulasByRole.get(role);
            formulas.add(formula);
        } else {
            this.roles.add(role);
            LinkedList<String> formulas = new LinkedList<String>();
            this.formulasByRole.put(role, formulas);
            formulas.add(formula);
        }
    }

    public String getProblemName() {
        return this.problemName;
    }

    public void setName(String name) {
        this.problemName = name;
    }

    public ProvabilityStatus getProblemStatus() {
        return this.status;
    }

    public void setProblemStatus(ProvabilityStatus status) {
        this.status = status;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String toString() {
        return "ProblemDescription [name=" + this.problemName + this.source + "]";
    }
}

