/*
 * Decompiled with CFR 0.152.
 */
package jtabwb.engine;

import jtabwb.engine.DFStack;
import jtabwb.engine.DFStackNode_Branch;
import jtabwb.engine.DFStackNode_BranchExists;
import jtabwb.engine.DFStackNode_MetaBacktrack;
import jtabwb.engine.EnginePlain;
import jtabwb.engine.ForceBranchFailure;
import jtabwb.engine.ForceBranchSuccess;
import jtabwb.engine.GoalNode;
import jtabwb.engine.ImplementationError;
import jtabwb.engine.IterationInfo;
import jtabwb.engine.RuleType;
import jtabwb.engine._AbstractFormula;
import jtabwb.engine._AbstractGoal;
import jtabwb.engine._AbstractRule;
import jtabwb.engine._BranchExistsRule;
import jtabwb.engine._MetaBacktrackRule;
import jtabwb.engine._OnRuleCompletedListener;
import jtabwb.engine._OnRuleResumedListener;
import jtabwb.engine._RegularRule;
import jtabwb.engine._RuleWithDetails;

class VerboseModeSupport {
    private static String INDENT_STRING = "    ";
    private static final String INFO_TAB = "    ";

    VerboseModeSupport() {
    }

    static void printInitialSetInfo(IterationInfo LAST_ITERATION_INFO, DFStack stack, _AbstractGoal initialNodeSet) {
        VerboseModeSupport.printIterationDetails(LAST_ITERATION_INFO, stack);
        VerboseModeSupport.iterationStepInfo("Initial goal: (0)\n%s", VerboseModeSupport.indentWithPrefix("| ", initialNodeSet.format()));
    }

    static void printIterationDetails(IterationInfo LAST_ITERATION_INFO, DFStack stack) {
        VerboseModeSupport.println("[%s] ------------------------------------ [%s]", String.valueOf(LAST_ITERATION_INFO.number_of_iterations), LAST_ITERATION_INFO.move.name());
        if (LAST_ITERATION_INFO.branch_point_added) {
            VerboseModeSupport.iterationStepInfo("Stack size: [%s], BRANCH POINT added", String.valueOf(stack.current_stack_size));
        } else if (LAST_ITERATION_INFO.backtrack_point_added) {
            VerboseModeSupport.iterationStepInfo("Stack size: [%s], BACKTRACK POINT added", String.valueOf(stack.current_stack_size));
        } else {
            VerboseModeSupport.iterationStepInfo("Stack size [%s]", String.valueOf(stack.current_stack_size));
        }
    }

    static void printIterationInfo(IterationInfo LAST_ITERATION_INFO, DFStack stack, RuleType ruleType, _AbstractRule nextStepSelectedRule, GoalNode currentGoal) {
        switch (ruleType) {
            case CLASH_DETECTION_RULE: {
                VerboseModeSupport.printIterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.iterationStepInfo("Rule name: %s", LAST_ITERATION_INFO.applied_rule.name());
                VerboseModeSupport.iterationStepInfo("Clash status: %s", LAST_ITERATION_INFO.current_node_set_status.name());
                break;
            }
            case META_BACKTRACK_RULE: {
                VerboseModeSupport.printIterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.printMetaBacktrackDetails((_MetaBacktrackRule)LAST_ITERATION_INFO.applied_rule, 0, nextStepSelectedRule);
                break;
            }
            case REGULAR: {
                _RegularRule rrule = (_RegularRule)LAST_ITERATION_INFO.applied_rule;
                VerboseModeSupport.printIterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.printRegularRuleApplicationDetails(rrule, 1, currentGoal);
                break;
            }
            case BRANCH_EXISTS: {
                VerboseModeSupport.printIterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.printBranchExistsDetails((_BranchExistsRule)LAST_ITERATION_INFO.applied_rule, 1, currentGoal);
                break;
            }
            case FORCE_BRANCH_FAILURE: {
                ForceBranchFailure rule = (ForceBranchFailure)LAST_ITERATION_INFO.applied_rule;
                VerboseModeSupport.printIterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.printForceBranchFailureDetails(rule, currentGoal);
                break;
            }
            case FORCE_BRANCH_SUCCESS: {
                ForceBranchSuccess rule = (ForceBranchSuccess)LAST_ITERATION_INFO.applied_rule;
                VerboseModeSupport.printIterationDetails(LAST_ITERATION_INFO, stack);
                VerboseModeSupport.printForceBranchSuccessDetails(rule, currentGoal);
                break;
            }
            default: {
                throw new ImplementationError();
            }
        }
    }

    static void printForceBranchSuccessDetails(ForceBranchSuccess appliedRule, GoalNode currentGoal) {
        VerboseModeSupport.iterationStepInfo("Rule name: %s", appliedRule.name());
        if (appliedRule instanceof _OnRuleCompletedListener) {
            VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo(" Details: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
    }

    static void printForceBranchFailureDetails(ForceBranchFailure appliedRule, GoalNode currentGoal) {
        VerboseModeSupport.iterationStepInfo("Rule name: %s", appliedRule.name());
        if (appliedRule instanceof _OnRuleCompletedListener) {
            VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo(" Details: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
    }

    static void printRegularRuleApplicationDetails(_RegularRule appliedRule, int treatedBranch, GoalNode currentGoal) {
        _AbstractFormula treatedFormula = appliedRule.mainFormula();
        VerboseModeSupport.iterationStepInfo(" Selected main formula [%s]: %s", treatedFormula == null ? "[NONE]" : treatedFormula.shortName(), treatedFormula == null ? "[NONE]" : treatedFormula.format());
        int totalNumberoOfConclusions = appliedRule.numberOfSubgoals();
        VerboseModeSupport.iterationStepInfo("Rule name [%s], conclusions [%d], treating branch [%d of %2$d]", appliedRule.name(), totalNumberoOfConclusions, treatedBranch);
        if (appliedRule instanceof _OnRuleCompletedListener) {
            VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _OnRuleResumedListener) {
            VerboseModeSupport.iterationStepInfo(" Added [on rule resumed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo(" Details: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
        VerboseModeSupport.iterationStepInfo("Generated node: %s", currentGoal.formatAsEngineNode());
    }

    static void printMetaBacktrackDetails(_MetaBacktrackRule appliedRule, int indexOfTreatedBacktrackRule, _AbstractRule nextStepSelectedRule) {
        VerboseModeSupport.iterationStepInfo(" Rule name [%s], rules to try [%d]", appliedRule.name(), appliedRule.totalNumberOfRules());
        RuleType nextStepType = RuleType.getType(nextStepSelectedRule);
        int totalNumberOfRules = appliedRule.totalNumberOfRules();
        switch (nextStepType) {
            case REGULAR: {
                VerboseModeSupport.iterationStepInfo("Rule [%d of %d] selected, [%s] on [%s]: %s", indexOfTreatedBacktrackRule + 1, totalNumberOfRules, nextStepSelectedRule.name(), ((_RegularRule)nextStepSelectedRule).mainFormula().shortName(), ((_RegularRule)nextStepSelectedRule).mainFormula().format());
                break;
            }
            case BRANCH_EXISTS: {
                VerboseModeSupport.iterationStepInfo("Rule [%d of %d] selected, [%s] on [%s]: %s", indexOfTreatedBacktrackRule + 1, totalNumberOfRules, nextStepSelectedRule.name(), ((_BranchExistsRule)nextStepSelectedRule).mainFormula().shortName(), ((_BranchExistsRule)nextStepSelectedRule).mainFormula().format());
                break;
            }
            default: {
                VerboseModeSupport.iterationStepInfo(" Rule [%d of %d] selected, [%s]", nextStepSelectedRule.name());
            }
        }
        if (appliedRule instanceof _OnRuleCompletedListener) {
            VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _OnRuleResumedListener) {
            VerboseModeSupport.iterationStepInfo(" Added [on rule resumed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo(" Details: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
    }

    static void printBranchExistsDetails(_BranchExistsRule appliedRule, int treatedBranch, GoalNode currentGoal) {
        _AbstractFormula treatedFormula = appliedRule.mainFormula();
        VerboseModeSupport.iterationStepInfo(" Selected main formula [%s]: %s", treatedFormula == null ? "[NONE]" : treatedFormula.shortName(), treatedFormula == null ? "[NONE]" : treatedFormula.format());
        VerboseModeSupport.iterationStepInfo("Rule name [%s], conclusions [%d], treating conclusion [%d of %2$d]", appliedRule.name(), appliedRule.numberOfBranchExistsSubgoals(), treatedBranch);
        if (appliedRule instanceof _OnRuleCompletedListener) {
            VerboseModeSupport.iterationStepInfo("Added [on rule completed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _OnRuleResumedListener) {
            VerboseModeSupport.iterationStepInfo(" Added [on rule resumed] listener for [%s]", appliedRule.name());
        }
        if (appliedRule instanceof _RuleWithDetails) {
            VerboseModeSupport.iterationStepInfo("Generated node: %s", VerboseModeSupport.indent(((_RuleWithDetails)((Object)appliedRule)).getDetails()));
        }
        VerboseModeSupport.iterationStepInfo("Generated node: %s", currentGoal.toString());
    }

    static void printNoMoreBacktrackPoints() {
        VerboseModeSupport.iterationStepInfo("No more backtrack points to resume; end of search.", new Object[0]);
    }

    static void printNoMoreBranchPoints() {
        VerboseModeSupport.iterationStepInfo("No more branch points to resume; end of search.", new Object[0]);
    }

    static void printResumedBacktrackPointInfo(EnginePlain engine, _AbstractRule rule) {
        VerboseModeSupport.printIterationDetails(engine.LAST_ITERATION_INFO, engine.stack);
        VerboseModeSupport.iterationStepInfo("Resumed BACKTRACK point. Node set %s", engine.stack.restored_DFStackNode.premiseEngineNode.formatAsRestoredEngineNode());
        if (engine.stack.restored_DFStackNode.appliedRule instanceof _MetaBacktrackRule) {
            VerboseModeSupport.iterationStepInfo("Backtrack rule type [%s]", RuleType.META_BACKTRACK_RULE.name());
            VerboseModeSupport.printMetaBacktrackDetails((_MetaBacktrackRule)engine.stack.restored_DFStackNode.appliedRule, ((DFStackNode_MetaBacktrack)engine.stack.restored_DFStackNode).getIndexOfLastTreatedRule(), rule);
        } else {
            VerboseModeSupport.iterationStepInfo("Backtrack rule type [%s]", RuleType.BRANCH_EXISTS.name());
            VerboseModeSupport.printBranchExistsDetails((_BranchExistsRule)engine.stack.restored_DFStackNode.appliedRule, ((DFStackNode_BranchExists)engine.stack.restored_DFStackNode).nextToTreat, engine.currentGoal);
        }
    }

    static void printResumedBranchPointInfo(EnginePlain engine) {
        VerboseModeSupport.printIterationDetails(engine.LAST_ITERATION_INFO, engine.stack);
        VerboseModeSupport.iterationStepInfo("Resumed BRANCH point generated at iteration [%d]", engine.stack.restored_DFStackNode.generated_at_iteration);
        VerboseModeSupport.iterationStepInfo("Node set %s", engine.stack.restored_DFStackNode.premiseEngineNode.formatAsRestoredEngineNode());
        _RegularRule appliedRule = (_RegularRule)engine.stack.restored_DFStackNode.appliedRule;
        VerboseModeSupport.printRegularRuleApplicationDetails(appliedRule, ((DFStackNode_Branch)engine.stack.restored_DFStackNode).nextConclusionToTreat, engine.currentGoal);
    }

    public static String indent(String str) {
        return str.replaceAll("\n", "\n" + INDENT_STRING);
    }

    static String indentWithPrefix(String prefix, String str) {
        String indent = String.valueOf(INDENT_STRING) + prefix;
        return String.valueOf(indent) + str.replaceAll("\n", "\n" + indent);
    }

    static void iterationStepInfo(String key, Object ... args) {
        System.out.println(INFO_TAB + String.format(key, args));
    }

    static void println(String key, Object ... args) {
        System.out.println(String.format(key, args));
    }

    static class MSG {
        MSG() {
        }

        static class ITERATION_INFO {
            static final String BACKTRACK_POINT_ADDED = "Stack size: [%s], BACKTRACK POINT added";
            static final String BRANCH_POINT_ADDED = "Stack size: [%s], BRANCH POINT added";
            static final String CLASH_RULE_NAME = "Rule name: %s";
            static final String FORCE_BRANCH_FAILURE_RULE_NAME = "Rule name: %s";
            static final String FORCE_BRANCH_SUCCESS_RULE_NAME = "Rule name: %s";
            static final String CLOSURE_CHECK = "Clash status: %s";
            static final String INITIAL_NODESET = "Initial goal: (0)\n%s";
            static final String MAIN_CYCLE_ITERATION = "[%s] ------------------------------------ [%s]";
            static final String STACK_SIZE = "Stack size [%s]";
            static final String STACK_TRACE_BEGIN = "Stack trace -->";
            static final String STACK_TRACE_END = "<--";

            ITERATION_INFO() {
            }
        }

        static class RESUMED_NODE_INFO {
            static final String BACKTRACK_POINT_RESUMED = "Resumed BACKTRACK point. Node set %s";
            static final String BACKTRACK_TYPE = "Backtrack rule type [%s]";
            static final String BRANCH_POINT_RESUMED = "Resumed BRANCH point generated at iteration [%d]";
            static final String BRANCH_POINT_RESUMED_NODE_SET = "Node set %s";
            static final String NO_MORE_BACKTRACK_POINTS = "No more backtrack points to resume; end of search.";
            static final String NO_MORE_BRANCH_POINTS = "No more branch points to resume; end of search.";

            RESUMED_NODE_INFO() {
            }
        }

        static class RULE_APPLICATION_DETAILS {
            static final String GENERATED_NODESET = "Generated node: %s";
            static final String BRANCH_EXISTS_NEXT_STEP = "Rule name [%s], conclusions [%d], treating conclusion [%d of %2$d]";
            static final String META_BACKTRACK_RULE_APPLICATION = " Rule name [%s], rules to try [%d]";
            static final String ON_RULE_COMPLETED_LISTENER = "Added [on rule completed] listener for [%s]";
            static final String ON_RULE_RESUMED_LISTENER = " Added [on rule resumed] listener for [%s]";
            static final String REGULAR_RULE_APPLICATION = "Rule name [%s], conclusions [%d], treating branch [%d of %2$d]";
            static final String RULE_DETAILS = " Details: %s";
            static final String SELECTED_BACKTRACK_RULE = " Rule [%d of %d] selected, [%s]";
            static final String SELECTED_BACKTRACK_RULE_FOR = "Rule [%d of %d] selected, [%s] on [%s]: %s";
            static final String SELECTED_MAIN_FORMULA = " Selected main formula [%s]: %s";

            RULE_APPLICATION_DETAILS() {
            }
        }
    }
}

