/*
 * Decompiled with CFR 0.152.
 */
package iplj.rgi3bu.tp;

import ipl.g3ied.sequents.G3iFormulaFactory;
import ipl.g3ied.sequents.MarkedSequentImplementations;
import iplj.rgi3bu.tp.RBuLatexCTreeFormatter;
import iplj.rgi3bu.tp.Strategy;
import jtabwb.engine.ProofSearchResult;
import jtabwb.engine.ProvabilityStatus;
import jtabwb.engine.ProverName;
import jtabwb.engine._Prover;
import jtabwb.engine._Strategy;
import jtabwb.tracesupport._LatexCTreeFormatter;
import jtabwb.tracesupport._LatexSupport;

public class RG3ibuProver
implements _Prover,
_LatexSupport {
    public static String RBU_DESCRIPTION = "Rbu Sequent Calculus for propositional Intuitionistic Logic.";
    public static String RBU_NAME = "rg3ibu";
    public static String RBU_VERSION = "1.0";
    private G3iFormulaFactory formulaFactory = new G3iFormulaFactory();
    private Strategy strategy = new Strategy(this.formulaFactory);
    private ProverName proverName;
    private MarkedSequentImplementations selectedSequentImplementation = MarkedSequentImplementations.SEQ_ON_ARRAY;

    public RG3ibuProver() {
        this.proverName = new ProverName(RBU_NAME, RBU_VERSION, this.proverVariantString(this.selectedSequentImplementation));
    }

    private String proverVariantString(MarkedSequentImplementations seqImpl) {
        return "seq=" + seqImpl.getName();
    }

    @Override
    public _Strategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ProverName getProverName() {
        return this.proverName;
    }

    @Override
    public ProvabilityStatus statusFor(ProofSearchResult result) {
        switch (result) {
            case SUCCESS: {
                return ProvabilityStatus.UNPROVABLE;
            }
            case FAILURE: {
                return ProvabilityStatus.PROVABLE;
            }
        }
        return null;
    }

    @Override
    public _LatexCTreeFormatter getLatexProofFormatter() {
        return new RBuLatexCTreeFormatter();
    }

    public void configure(MarkedSequentImplementations implem) {
        this.selectedSequentImplementation = implem;
        this.proverName.setVariant(this.proverVariantString(this.selectedSequentImplementation));
    }
}

